/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import com.hbm.lib.ModSounds;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.Level;

public class Duck
extends Chicken {
    public Duck(EntityType<? extends Chicken> type, Level level) {
        super(type, level);
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.DUCK.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)ModSounds.DUCK.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.DUCK.get();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Chicken.createAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public void die(DamageSource damageSource) {
        if (!this.level().isClientSide) {
            MutableComponent message = this.getDisplayName().copy();
            message.append((Component)Component.literal((String)" died!"));
            this.level().getServer().getPlayerList().broadcastSystemMessage((Component)message, false);
        }
        super.die(damageSource);
    }
}

