/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.lib.ModDamageSource;
import com.hbm.lib.ModSounds;
import com.hbm.network.toclient.ParticleBurst;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.network.PacketDistributor;

public class Rubble
extends ThrowableProjectile {
    private static final EntityDataAccessor<String> BLOCK_ID = SynchedEntityData.defineId(Rubble.class, (EntityDataSerializer)EntityDataSerializers.STRING);

    public Rubble(EntityType<? extends Rubble> type, Level level) {
        super(type, level);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (result instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)result;
            entityHitResult.getEntity().hurt(new DamageSource((Holder)entityHitResult.getEntity().level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ModDamageSource.RUBBLE)), 15.0f);
        }
        if (this.tickCount > 2) {
            this.discard();
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), ModSounds.DEBRIS, SoundSource.BLOCKS, 1.5f, 1.0f);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (double)250.0, (CustomPacketPayload)new ParticleBurst(BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()), this.getBlock()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(BLOCK_ID, (Object)"minecraft:stone");
    }

    public Block getBlock() {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)((String)this.entityData.get(BLOCK_ID))));
    }

    public void setBlock(Block block) {
        this.entityData.set(BLOCK_ID, (Object)BuiltInRegistries.BLOCK.getKey((Object)block).toString());
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putString("Block", (String)this.entityData.get(BLOCK_ID));
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.entityData.set(BLOCK_ID, (Object)tag.getString("Block"));
    }
}

