/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.blocks.ModBlocks;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockMutatorDebris;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.ExplosionEffectStandard;
import com.hbm.lib.ModDamageSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class Shrapnel
extends ThrowableProjectile {
    private static final EntityDataAccessor<Byte> TYPE = SynchedEntityData.defineId(Shrapnel.class, (EntityDataSerializer)EntityDataSerializers.BYTE);

    public Shrapnel(EntityType<? extends ThrowableProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TYPE, (Object)0);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && (Byte)this.entityData.get(TYPE) == 1) {
            this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.FLAME, true, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        }
    }

    protected void onHit(HitResult result) {
        block11: {
            block13: {
                byte b;
                block12: {
                    BlockPos pos;
                    BlockHitResult bhr;
                    super.onHit(result);
                    if (result instanceof EntityHitResult) {
                        EntityHitResult ehr = (EntityHitResult)result;
                        DamageSource src = new DamageSource((Holder)ehr.getEntity().level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ModDamageSource.SHRAPNEL));
                        ehr.getEntity().hurt(src, 15.0f);
                    }
                    if (this.tickCount <= 5) break block11;
                    if (!this.level().isClientSide) {
                        this.discard();
                    }
                    if ((b = ((Byte)this.entityData.get(TYPE)).byteValue()) != 2 && b != 4) break block12;
                    if (this.level().isClientSide) break block13;
                    if (this.getDeltaMovement().y < -0.2 && result instanceof BlockHitResult) {
                        bhr = (BlockHitResult)result;
                        pos = bhr.getBlockPos().above();
                        if (this.level().getBlockState(pos).canBeReplaced()) {
                            this.level().setBlock(pos, b == 2 ? ((Block)ModBlocks.VOLCANIC_LAVA_BLOCK.get()).defaultBlockState() : ((Block)ModBlocks.RAD_LAVA_BLOCK.get()).defaultBlockState(), 3);
                        }
                        BlockPos base = bhr.getBlockPos();
                        for (int x = -1; x <= 1; ++x) {
                            for (int y = 0; y <= 2; ++y) {
                                for (int z = -1; z <= 1; ++z) {
                                    BlockPos p = base.offset(x, y, z);
                                    if (!this.level().getBlockState(p).isAir()) continue;
                                    this.level().setBlock(p, ((Block)ModBlocks.GAS_MONOXIDE.get()).defaultBlockState(), 3);
                                }
                            }
                        }
                    }
                    if (!(this.getDeltaMovement().y > 0.0) || !(result instanceof BlockHitResult)) break block13;
                    bhr = (BlockHitResult)result;
                    pos = bhr.getBlockPos();
                    ExplosionVNT vnt = new ExplosionVNT(this.level(), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 7.0f);
                    vnt.setBlockAllocator(new BlockAllocatorStandard());
                    vnt.setBlockProcessor(new BlockProcessorStandard().setNoDrop().withBlockEffect(new BlockMutatorDebris(b == 2 ? (Block)ModBlocks.VOLCANIC_LAVA_BLOCK.get() : (Block)ModBlocks.RAD_LAVA_BLOCK.get())));
                    vnt.setSFX(new ExplosionEffectStandard());
                    vnt.explode();
                    break block13;
                }
                if (b == 3 && result instanceof BlockHitResult) {
                    BlockHitResult bhr = (BlockHitResult)result;
                    BlockPos pos = bhr.getBlockPos().above();
                    if (this.level().getBlockState(pos).canBeReplaced()) {
                        this.level().setBlock(pos, ((Block)ModBlocks.BLOCK_SCRAP.get()).defaultBlockState(), 3);
                    }
                } else {
                    for (int i = 0; i < 5; ++i) {
                        this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.LAVA, true, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                    }
                }
            }
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public byte getShrapnelType() {
        return (Byte)this.entityData.get(TYPE);
    }

    public void setTrail(boolean b) {
        this.entityData.set(TYPE, (Object)((byte)(b ? 1 : 0)));
    }

    public void setVolcano(boolean b) {
        this.entityData.set(TYPE, (Object)((byte)(b ? 2 : 0)));
    }

    public void setWatz(boolean b) {
        this.entityData.set(TYPE, (Object)((byte)(b ? 3 : 0)));
    }

    public void setRadVolcano(boolean b) {
        this.entityData.set(TYPE, (Object)((byte)(b ? 4 : 0)));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putByte("Type", ((Byte)this.entityData.get(TYPE)).byteValue());
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.entityData.set(TYPE, (Object)tag.getByte("Type"));
    }
}

