/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.entity.projectile.ProjectileNT;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class ThrowableInterp
extends ProjectileNT {
    protected int turnProgress;
    protected double syncPosX;
    protected double syncPosY;
    protected double syncPosZ;
    protected double syncYaw;
    protected double syncPitch;
    @OnlyIn(value=Dist.CLIENT)
    protected double velocityX;
    @OnlyIn(value=Dist.CLIENT)
    protected double velocityY;
    @OnlyIn(value=Dist.CLIENT)
    protected double velocityZ;

    protected ThrowableInterp(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void tick() {
        if (!this.level().isClientSide) {
            super.tick();
        } else {
            this.xo = this.getX();
            this.yo = this.getY();
            this.zo = this.getZ();
            if (this.turnProgress > 0) {
                double interpX = this.getX() + (this.syncPosX - this.getX()) / (double)this.turnProgress;
                double interpY = this.getY() + (this.syncPosY - this.getY()) / (double)this.turnProgress;
                double interpZ = this.getZ() + (this.syncPosZ - this.getZ()) / (double)this.turnProgress;
                double d = Mth.wrapDegrees((double)(this.syncYaw - (double)this.getYRot()));
                this.setYRot((float)((double)this.getYRot() + d / (double)this.turnProgress));
                this.setXRot((float)((double)this.getXRot() + (this.syncPitch - (double)this.getXRot()) / (double)this.turnProgress));
                --this.turnProgress;
                this.setPos(interpX, interpY, interpZ);
            } else {
                this.setPos(this.getX(), this.getY(), this.getZ());
            }
        }
    }

    @Override
    public void setDeltaMovement(double x, double y, double z) {
        this.velocityX = x;
        this.velocityY = y;
        this.velocityZ = z;
        super.setDeltaMovement(x, y, z);
    }

    public void setPositionAndRotation2(double x, double y, double z, float yaw, float pitch, int theNumberThree) {
        this.syncPosX = x;
        this.syncPosY = y;
        this.syncPosZ = z;
        this.syncYaw = yaw;
        this.syncPitch = pitch;
        this.turnProgress = theNumberThree + this.approachNum();
        this.setDeltaMovement(this.velocityX, this.velocityY, this.velocityZ);
    }

    public int approachNum() {
        return 0;
    }
}

