/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.lib.ModDamageSource;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class ExplosionNukeGeneric {
    public static void incrementRad(Level level, double posX, double posY, double posZ, float mult) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) + Math.abs(j) >= 4) continue;
                ChunkRadiationManager.proxy.incrementRad(level, new BlockPos((int)Math.floor(posX + (double)(i * 16)), (int)Math.floor(posY), (int)Math.floor(posZ + (double)(j * 16))), 50.0f / (float)(Math.abs(i) + Math.abs(j) + 1) * mult);
            }
        }
    }

    public static void dealDamage(Level level, double x, double y, double z, double radius) {
        ExplosionNukeGeneric.dealDamage(level, x, y, z, radius, 250.0f);
    }

    private static void dealDamage(Level level, double x, double y, double z, double radius, float maxDamage) {
        List entities = level.getEntities(null, new AABB(x, y, z, x, y, z).inflate(radius));
        for (Entity entity : entities) {
            double distSq = entity.distanceToSqr(x, y, z);
            if (!(distSq <= radius * radius)) continue;
            double entX = entity.getX();
            double entY = entity.getY() + (double)entity.getEyeHeight();
            double entZ = entity.getZ();
            if (ExplosionNukeGeneric.isExplosionExempt(entity) || ExplosionNukeGeneric.isObstructed(level, x, y, z, entX, entY, entZ)) continue;
            double dist = Math.sqrt(distSq);
            double damage = (double)maxDamage * (radius - dist) / radius;
            DamageSource src = new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ModDamageSource.NUCLEAR_BLAST));
            entity.hurt(src, (float)damage);
            entity.setRemainingFireTicks(100);
            double knockX = entX - x;
            double knockY = entity.getY() + (double)entity.getEyeHeight() - y;
            double knockZ = entZ - z;
            Vec3 knock = new Vec3(knockX, knockY, knockZ).normalize().scale(0.2);
            entity.setDeltaMovement(entity.getDeltaMovement().add(knock));
        }
    }

    public static boolean isObstructed(Level level, double x, double y, double z, double a, double b, double c) {
        return level.clip(new ClipContext(new Vec3(x, y, z), new Vec3(a, b, c), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty())).getType() != HitResult.Type.MISS;
    }

    private static boolean isExplosionExempt(Entity entity) {
        if (entity instanceof Ocelot) {
            return true;
        }
        return entity instanceof Player && ((Player)entity).isCreative();
    }
}

