/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.interfaces.IExplosionRay;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ExplosionNukeRayBatched
implements IExplosionRay {
    public Map<ChunkPos, List<FloatTriplet>> perChunk = new HashMap<ChunkPos, List<FloatTriplet>>();
    public List<ChunkPos> orderedChunks = new ArrayList<ChunkPos>();
    private CoordComparator comparator = new CoordComparator();
    int posX;
    int posY;
    int posZ;
    Level level;
    int strength;
    int length;
    int speed;
    int gspNumMax;
    int gspNum;
    double gspX;
    double gspY;
    public boolean isAusf3Complete = false;

    public ExplosionNukeRayBatched(Level level, int x, int y, int z, int strength, int speed, int length) {
        this.level = level;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.strength = strength;
        this.speed = speed;
        this.length = length;
        this.gspNumMax = (int)(7.853981633974483 * Math.pow(this.strength, 2.0));
        this.gspNum = 1;
        this.gspX = Math.PI;
        this.gspY = 0.0;
    }

    private void generateGspUp() {
        if (this.gspNum < this.gspNumMax) {
            int k = this.gspNum + 1;
            double hk = -1.0 + 2.0 * ((double)k - 1.0) / ((double)this.gspNumMax - 1.0);
            this.gspX = Math.acos(hk);
            double prev_lon = this.gspY;
            double lon = prev_lon + 3.6 / Math.sqrt(this.gspNumMax) / Math.sqrt(1.0 - hk * hk);
            this.gspY = lon % (Math.PI * 2);
        } else {
            this.gspX = 0.0;
            this.gspY = 0.0;
        }
        ++this.gspNum;
    }

    private Vec3 getSpherical2cartesian() {
        double dx = Math.sin(this.gspX) * Math.cos(this.gspY);
        double dz = Math.sin(this.gspX) * Math.sin(this.gspY);
        double dy = Math.cos(this.gspX);
        return new Vec3(dx, dy, dz);
    }

    public void collectTip(int count) {
        int amountProcessed = 0;
        while (this.gspNumMax >= this.gspNum) {
            Vec3 vec = this.getSpherical2cartesian();
            int length = (int)Math.ceil(this.strength);
            float res = this.strength;
            FloatTriplet lastPos = null;
            HashSet<ChunkPos> chunkCoords = new HashSet<ChunkPos>();
            for (int i = 0; i < length && i <= this.length; ++i) {
                float x0 = (float)((double)this.posX + vec.x * (double)i);
                float y0 = (float)((double)this.posY + vec.y * (double)i);
                float z0 = (float)((double)this.posZ + vec.z * (double)i);
                int iX = (int)Math.floor(x0);
                int iY = (int)Math.floor(y0);
                int iZ = (int)Math.floor(z0);
                double fac = 100.0 - (double)i / (double)length * 100.0;
                fac *= 0.07;
                BlockPos pos = new BlockPos(iX, iY, iZ);
                BlockState state = this.level.getBlockState(pos);
                if (state.getFluidState().isEmpty()) {
                    res -= (float)Math.pow(ExplosionNukeRayBatched.masqueradeResistance(this.level, state, pos), 7.5 - fac);
                }
                if (res > 0.0f && !state.isAir()) {
                    lastPos = new FloatTriplet(x0, y0, z0);
                    ChunkPos chunkPos = new ChunkPos(iX >> 4, iZ >> 4);
                    chunkCoords.add(chunkPos);
                }
                if (res <= 0.0f || i + 1 >= this.length || i == length - 1) break;
            }
            for (ChunkPos pos : chunkCoords) {
                List<FloatTriplet> triplets = this.perChunk.get(pos);
                if (triplets == null) {
                    triplets = new ArrayList<FloatTriplet>();
                    this.perChunk.put(pos, triplets);
                }
                triplets.add(lastPos);
            }
            this.generateGspUp();
            if (++amountProcessed < count) continue;
            return;
        }
        this.orderedChunks.addAll(this.perChunk.keySet());
        this.orderedChunks.sort(this.comparator);
        this.isAusf3Complete = true;
    }

    public static float masqueradeResistance(Level level, BlockState state, BlockPos pos) {
        Block block = level.getBlockState(pos).getBlock();
        if (block == Blocks.SANDSTONE) {
            return Blocks.STONE.defaultBlockState().getExplosionResistance((BlockGetter)level, pos, null);
        }
        if (block == Blocks.OBSIDIAN) {
            return Blocks.STONE.defaultBlockState().getExplosionResistance((BlockGetter)level, pos, null) * 3.0f;
        }
        return state.getExplosionResistance((BlockGetter)level, pos, null);
    }

    public void processChunk() {
        if (this.perChunk.isEmpty()) {
            return;
        }
        ChunkPos coord = this.orderedChunks.get(0);
        List<FloatTriplet> list = this.perChunk.get(coord);
        HashSet<BlockPos> toRem = new HashSet<BlockPos>();
        HashSet<BlockPos> toRemTips = new HashSet<BlockPos>();
        int chunkX = coord.x;
        int chunkZ = coord.z;
        int enter = Math.min(Math.abs(this.posX - (chunkX << 4)), Math.abs(this.posZ - (chunkZ << 4))) - 16;
        enter = Math.max(enter, 0);
        block0: for (FloatTriplet triplet : list) {
            float x = triplet.xCoord;
            float y = triplet.yCoord;
            float z = triplet.zCoord;
            Vec3 vec = new Vec3((double)(x - (float)this.posX), (double)(y - (float)this.posY), (double)(z - (float)this.posZ));
            double pX = vec.x / vec.length();
            double pY = vec.y / vec.length();
            double pZ = vec.z / vec.length();
            int tipX = (int)Math.floor(x);
            int tipY = (int)Math.floor(y);
            int tipZ = (int)Math.floor(z);
            boolean inChunk = false;
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            int i = enter;
            while ((double)i < vec.length()) {
                int x0 = (int)Math.floor((double)this.posX + pX * (double)i);
                int y0 = (int)Math.floor((double)this.posY + pY * (double)i);
                int z0 = (int)Math.floor((double)this.posZ + pZ * (double)i);
                mutablePos.set(x0, y0, z0);
                BlockState state = this.level.getBlockState((BlockPos)mutablePos);
                if (x0 >> 4 != chunkX || z0 >> 4 != chunkZ) {
                    if (inChunk) {
                        continue block0;
                    }
                } else {
                    inChunk = true;
                    if (!state.isAir()) {
                        BlockPos pos = new BlockPos(x0, y0, z0);
                        if (x0 == tipX && y0 == tipY && z0 == tipZ) {
                            toRemTips.add(pos);
                        }
                        toRem.add(pos);
                    }
                }
                ++i;
            }
        }
        for (BlockPos pos : toRem) {
            if (toRemTips.contains(pos)) {
                this.handleTip(pos.getX(), pos.getY(), pos.getZ());
                continue;
            }
            this.level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
        }
        this.perChunk.remove(coord);
        this.orderedChunks.remove(0);
    }

    protected void handleTip(int x, int y, int z) {
        this.level.setBlock(new BlockPos(x, y, z), Blocks.AIR.defaultBlockState(), 3);
    }

    @Override
    public boolean isComplete() {
        return this.isAusf3Complete && this.perChunk.isEmpty();
    }

    @Override
    public void cacheChunksTick(int time) {
        if (!this.isAusf3Complete) {
            this.collectTip(this.speed * 10);
        }
    }

    @Override
    public void destructionTick(int time) {
        if (!this.isAusf3Complete) {
            return;
        }
        long start = System.currentTimeMillis();
        while (!this.perChunk.isEmpty() && System.currentTimeMillis() < start + (long)time) {
            this.processChunk();
        }
    }

    @Override
    public void cancel() {
        this.isAusf3Complete = true;
        if (this.perChunk != null) {
            this.perChunk.clear();
        }
        if (this.orderedChunks != null) {
            this.orderedChunks.clear();
        }
    }

    public class CoordComparator
    implements Comparator<ChunkPos> {
        @Override
        public int compare(ChunkPos o1, ChunkPos o2) {
            int chunkX = ExplosionNukeRayBatched.this.posX >> 4;
            int chunkZ = ExplosionNukeRayBatched.this.posZ >> 4;
            int diff1 = Math.abs(chunkX - o1.x) + Math.abs(chunkZ - o1.z);
            int diff2 = Math.abs(chunkX - o2.x) + Math.abs(chunkZ - o2.z);
            return diff1 - diff2;
        }
    }

    public static class FloatTriplet {
        public float xCoord;
        public float yCoord;
        public float zCoord;

        public FloatTriplet(float x, float y, float z) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
        }
    }
}

