/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.IBlockMutator;
import com.hbm.explosion.vanillant.interfaces.IBlockProcessor;
import com.hbm.explosion.vanillant.interfaces.IDropChanceMutator;
import com.hbm.explosion.vanillant.interfaces.IFortuneMutator;
import com.hbm.explosion.vanillant.standard.DropChanceMutatorStandard;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class BlockProcessorStandard
implements IBlockProcessor {
    protected IDropChanceMutator chance;
    protected IFortuneMutator fortune;
    protected IBlockMutator convert;

    public BlockProcessorStandard withChance(IDropChanceMutator chance) {
        this.chance = chance;
        return this;
    }

    public BlockProcessorStandard withFortune(IFortuneMutator fortune) {
        this.fortune = fortune;
        return this;
    }

    public BlockProcessorStandard withBlockEffect(IBlockMutator convert) {
        this.convert = convert;
        return this;
    }

    @Override
    public void process(ExplosionVNT explosion, Level level, double x, double y, double z, HashSet<BlockPos> affectedBlocks) {
        BlockState state;
        Iterator<BlockPos> iterator = affectedBlocks.iterator();
        float dropChance = 1.0f / explosion.size;
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (!state.isAir()) {
                if (state.canDropFromExplosion((BlockGetter)level, pos, null)) {
                    if (this.chance != null) {
                        dropChance = this.chance.mutateDropChance(explosion, block, pos, dropChance);
                    }
                    int dropFortune = this.fortune == null ? 0 : this.fortune.mutateFortune(explosion, block, pos);
                    Holder.Reference fortuneEnchant = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE);
                    ItemStack toolWith = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
                    if (dropFortune > 0) {
                        toolWith.enchant((Holder)fortuneEnchant, dropFortune);
                    }
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)toolWith).withParameter(LootContextParams.BLOCK_STATE, (Object)state).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)level.getBlockEntity(pos));
                        List drops = state.getDrops(builder);
                        for (ItemStack drop : drops) {
                            if (!(serverLevel.random.nextFloat() <= dropChance)) continue;
                            Block.popResource((Level)serverLevel, (BlockPos)pos, (ItemStack)drop);
                        }
                    }
                }
                state.onBlockExploded(level, pos, explosion.compat);
                if (this.convert == null) continue;
                this.convert.mutatePre(explosion, state, pos);
                continue;
            }
            iterator.remove();
        }
        if (this.convert != null) {
            for (BlockPos pos : affectedBlocks) {
                state = level.getBlockState(pos);
                if (!state.isAir()) continue;
                this.convert.mutatePost(explosion, pos);
            }
        }
    }

    public BlockProcessorStandard setNoDrop() {
        this.chance = new DropChanceMutatorStandard(0.0f);
        return this;
    }

    public BlockProcessorStandard setAllDrop() {
        this.chance = new DropChanceMutatorStandard(1.0f);
        return this;
    }

    public BlockProcessorStandard setFortune(final int fortune) {
        this.fortune = new IFortuneMutator(){

            @Override
            public int mutateFortune(ExplosionVNT explosion, Block block, BlockPos pos) {
                return fortune;
            }
        };
        return this;
    }
}

