/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.EntityProcessorCross;
import com.hbm.items.weapon.sedna.factory.ConfettiUtil;
import com.hbm.util.DamageResistanceHandler;
import com.hbm.util.DamageSourceNT;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class EntityProcessorCrossSmooth
extends EntityProcessorCross {
    protected float fixedDamage;
    protected float pierceDT = 0.0f;
    protected float pierceDR = 0.0f;
    protected DamageResistanceHandler.DamageClass clazz = DamageResistanceHandler.DamageClass.EXPLOSION;

    public EntityProcessorCrossSmooth(double nodeDist, float fixedDamage) {
        super(nodeDist);
        this.fixedDamage = fixedDamage;
        this.setAllowSelfDamage();
    }

    public EntityProcessorCrossSmooth setupPiercing(float pierceDT, float pierceDR) {
        this.pierceDT = pierceDT;
        this.pierceDR = pierceDR;
        return this;
    }

    public EntityProcessorCrossSmooth setDamageClass(DamageResistanceHandler.DamageClass clazz) {
        this.clazz = clazz;
        return this;
    }

    @Override
    public void attackEntity(Entity entity, ExplosionVNT source, float amount) {
        if (!entity.isAlive()) {
            return;
        }
        if (source.exploder == entity) {
            amount *= 0.5f;
        }
        DamageSourceNT dmg = EntityProcessorCrossSmooth.getDamage(entity.level(), this.clazz);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.hurt(entity.level().damageSources().source(DamageTypes.EXPLOSION), amount);
            if (!entity.isAlive()) {
                ConfettiUtil.decideConfetti(livingEntity, dmg);
            }
        } else {
            entity.hurt((DamageSource)dmg, amount);
        }
    }

    @Override
    public float calculateDamage(double distanceScaled, double density, double knockback, float size) {
        if (density < 0.125) {
            return 0.0f;
        }
        return (float)((double)this.fixedDamage * (1.0 - distanceScaled));
    }

    public static DamageSourceNT getDamage(Level level, DamageResistanceHandler.DamageClass dmgClass) {
        String name = "minecraft:generic";
        switch (dmgClass) {
            case IN_FIRE: {
                name = "minecraft:in_fire";
                break;
            }
            case EXPLOSION: {
                name = "minecraft:explosion";
                break;
            }
        }
        DamageSourceNT dmg = new DamageSourceNT(level, name);
        switch (dmgClass) {
            case PHYSICAL: {
                dmg.setProjectile();
                break;
            }
            case IN_FIRE: {
                dmg.setFireDamage();
                break;
            }
            case EXPLOSION: {
                dmg.setExplosion();
                break;
            }
        }
        return dmg;
    }
}

