/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant.standard;

import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.interfaces.IExplosionSFX;
import com.hbm.network.toclient.VanillaExplosionLike;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

public class ExplosionEffectStandard
implements IExplosionSFX {
    @Override
    public void doEffect(ExplosionVNT explosion, Level level, double x, double y, double z, float size) {
        level.playSound(null, x, y, z, (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 4.0f, (1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.2f) * 0.7f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)x, (double)y, (double)z, (double)250.0, (CustomPacketPayload)new VanillaExplosionLike(x, y, z, explosion.size, explosion.compat.getToBlow()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void performClient(ClientLevel level, double x, double y, double z, float size, List<BlockPos> affectedBlocks) {
        if (size >= 2.0f) {
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, x, y, z, 1.0, 0.0, 0.0);
        } else {
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, x, y, z, 1.0, 0.0, 0.0);
        }
        for (BlockPos pos : affectedBlocks) {
            int pX = pos.getX();
            int pY = pos.getY();
            int pZ = pos.getZ();
            double oX = (float)pX + level.random.nextFloat();
            double oY = (float)pY + level.random.nextFloat();
            double oZ = (float)pZ + level.random.nextFloat();
            double dX = oX - x;
            double dY = oY - y;
            double dZ = oZ - z;
            double delta = Math.sqrt(dX * dX + dY * dY + dZ * dZ) / 1.0;
            dX /= delta;
            dY /= delta;
            dZ /= delta;
            double mod = 0.5 / (delta / (double)size + 0.1);
            level.addParticle((ParticleOptions)ParticleTypes.CLOUD, (oX + x * 1.0) / 2.0, (oY + y * 1.0) / 2.0, (oZ + z * 1.0) / 2.0, dX *= (mod *= (double)(level.random.nextFloat() * level.random.nextFloat() + 0.3f)), dY *= mod, dZ *= mod);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, oX, oY, oZ, dX, dY, dZ);
        }
    }
}

