/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.extprop;

import com.hbm.handler.KeyHandler;
import com.hbm.lib.ModAttachments;
import com.hbm.network.toclient.InformPlayer;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public class HbmPlayerAttachments {
    public static final StreamCodec<RegistryFriendlyByteBuf, HbmPlayerAttachments> STREAM_CODEC = StreamCodec.of((buf, props) -> buf.writeNbt((Tag)props.saveNBTData()), buf -> {
        HbmPlayerAttachments props = new HbmPlayerAttachments();
        props.loadNBTData(buf.readNbt());
        return props;
    });
    public static final Codec<HbmPlayerAttachments> CODEC = CompoundTag.CODEC.xmap(tag -> {
        HbmPlayerAttachments props = new HbmPlayerAttachments();
        props.loadNBTData((CompoundTag)tag);
        return props;
    }, HbmPlayerAttachments::saveNBTData);
    public boolean hasReceivedBook = false;
    public boolean enableHUD = true;
    public boolean enableBackpack = true;
    public boolean enableMagnet = true;
    private final boolean[] keysPressed = new boolean[KeyHandler.EnumKeybind.values().length];
    public boolean dashActivated = true;
    public static final int dashCooldownLength = 5;
    public int dashCooldown = 0;
    public int totalDashCount = 0;
    public int stamina = 0;
    public static final int plinkCooldownLength = 10;
    public int plinkCooldown = 0;
    public float shield = 0.0f;
    public float maxShield = 0.0f;
    public int lastDamage = 0;
    public static final float shieldCap = 100.0f;
    public int reputation;
    public boolean isOnLadder = false;

    public static HbmPlayerAttachments getData(Player player) {
        return (HbmPlayerAttachments)player.getData(ModAttachments.PLAYER_ATTACHMENT);
    }

    public boolean getKeyPressed(KeyHandler.EnumKeybind key) {
        return this.keysPressed[key.ordinal()];
    }

    public boolean isJetpackActive() {
        return this.enableBackpack && this.getKeyPressed(KeyHandler.EnumKeybind.JETPACK);
    }

    public boolean isMagnetActive() {
        return this.enableMagnet;
    }

    public void setKeyPressed(Player player, KeyHandler.EnumKeybind key, boolean pressed) {
        if (!this.getKeyPressed(key) && pressed) {
            HbmPlayerAttachments props;
            if (key == KeyHandler.EnumKeybind.TOGGLE_JETPACK && !player.level().isClientSide) {
                props = HbmPlayerAttachments.getData(player);
                props.enableBackpack = !props.enableBackpack;
                player.setData(ModAttachments.PLAYER_ATTACHMENT, (Object)props);
                if (props.enableBackpack) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new InformPlayer((Component)Component.literal((String)"Jetpack ON").withStyle(ChatFormatting.GREEN), 5, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new InformPlayer((Component)Component.literal((String)"Jetpack OFF").withStyle(ChatFormatting.RED), 5, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (key == KeyHandler.EnumKeybind.TOGGLE_MAGNET && !player.level().isClientSide) {
                props = HbmPlayerAttachments.getData(player);
                props.enableMagnet = !props.enableMagnet;
                player.setData(ModAttachments.PLAYER_ATTACHMENT, (Object)props);
                if (props.enableMagnet) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new InformPlayer((Component)Component.literal((String)"Magnet ON").withStyle(ChatFormatting.GREEN), 6, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new InformPlayer((Component)Component.literal((String)"Magnet OFF").withStyle(ChatFormatting.RED), 6, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            if (key == KeyHandler.EnumKeybind.TOGGLE_HEAD && !player.level().isClientSide) {
                props = HbmPlayerAttachments.getData(player);
                props.enableMagnet = !props.enableMagnet;
                player.setData(ModAttachments.PLAYER_ATTACHMENT, (Object)props);
                if (props.enableHUD) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new InformPlayer((Component)Component.literal((String)"HUD ON").withStyle(ChatFormatting.GREEN), 7, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                } else {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new InformPlayer((Component)Component.literal((String)"HUD OFF").withStyle(ChatFormatting.RED), 7, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
        this.keysPressed[key.ordinal()] = pressed;
    }

    public void setDashCooldown(int cooldown) {
        this.dashCooldown = cooldown;
    }

    public int getDashCooldown() {
        return this.dashCooldown;
    }

    public void setStamina(int stamina) {
        this.stamina = stamina;
    }

    public int getStamina() {
        return this.stamina;
    }

    public void setDashCount(int count) {
        this.totalDashCount = count;
    }

    public int getDashCount() {
        return this.totalDashCount;
    }

    public void serialize(ByteBuf buf) {
        buf.writeBoolean(this.hasReceivedBook);
        buf.writeFloat(this.shield);
        buf.writeFloat(this.maxShield);
        buf.writeBoolean(this.enableBackpack);
        buf.writeBoolean(this.enableHUD);
        buf.writeInt(this.reputation);
        buf.writeBoolean(this.isOnLadder);
        buf.writeBoolean(this.enableMagnet);
    }

    public void deserialize(ByteBuf buf) {
        if (buf.readableBytes() > 0) {
            this.hasReceivedBook = buf.readBoolean();
            this.shield = buf.readFloat();
            this.maxShield = buf.readFloat();
            this.enableBackpack = buf.readBoolean();
            this.enableHUD = buf.readBoolean();
            this.reputation = buf.readInt();
            this.isOnLadder = buf.readBoolean();
            this.enableMagnet = buf.readBoolean();
        }
    }

    public CompoundTag saveNBTData() {
        CompoundTag props = new CompoundTag();
        props.putBoolean("hasReceivedBook", this.hasReceivedBook);
        props.putFloat("shield", this.shield);
        props.putFloat("maxShield", this.maxShield);
        props.putBoolean("enableBackpack", this.enableBackpack);
        props.putBoolean("enableHUD", this.enableHUD);
        props.putInt("reputation", this.reputation);
        props.putBoolean("isOnLadder", this.isOnLadder);
        props.putBoolean("enableMagnet", this.enableMagnet);
        return props;
    }

    public void loadNBTData(CompoundTag props) {
        if (props != null) {
            this.hasReceivedBook = props.getBoolean("hasReceivedBook");
            this.shield = props.getFloat("shield");
            this.maxShield = props.getFloat("maxShield");
            this.enableBackpack = props.getBoolean("enableBackpack");
            this.enableHUD = props.getBoolean("enableHUD");
            this.reputation = props.getInt("reputation");
            this.isOnLadder = props.getBoolean("isOnLadder");
            this.enableMagnet = props.getBoolean("enableMagnet");
        }
    }
}

