/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.items.armor.ItemArmorMod;
import com.hbm.util.TagsUtilDegradation;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ArmorModHandler {
    public static final int HELMET_ONLY = 0;
    public static final int PLATE_ONLY = 1;
    public static final int LEGS_ONLY = 2;
    public static final int BOOTS_ONLY = 3;
    public static final int SERVOS = 4;
    public static final int CLADDING = 5;
    public static final int KEVLAR = 6;
    public static final int EXTRA = 7;
    public static final int BATTERY = 8;
    public static final int MOD_SLOTS = 9;
    public static final String MOD_COMPOUND_KEY = "ntm_armor_mods";
    public static final String MOD_SLOT_KEY = "mod_slot_";

    public static boolean isApplicable(ItemStack armor, ItemStack mod) {
        if (armor.isEmpty() || mod.isEmpty()) {
            return false;
        }
        Item item = armor.getItem();
        if (!(item instanceof ArmorItem)) {
            return false;
        }
        ArmorItem aItem = (ArmorItem)item;
        Item item2 = mod.getItem();
        if (!(item2 instanceof ItemArmorMod)) {
            return false;
        }
        ItemArmorMod aMod = (ItemArmorMod)item2;
        ArmorItem.Type type = aItem.getType();
        return type == ArmorItem.Type.HELMET && aMod.helmet || type == ArmorItem.Type.CHESTPLATE && aMod.chestplate || type == ArmorItem.Type.LEGGINGS && aMod.leggings || type == ArmorItem.Type.BOOTS && aMod.boots;
    }

    public static void applyMod(Level level, ItemStack armor, ItemStack mod) {
        CompoundTag tag = TagsUtilDegradation.getTag(armor);
        if (!tag.contains(MOD_COMPOUND_KEY)) {
            tag.put(MOD_COMPOUND_KEY, (Tag)new CompoundTag());
        }
        CompoundTag mods = tag.getCompound(MOD_COMPOUND_KEY);
        ItemArmorMod aMod = (ItemArmorMod)mod.getItem();
        int slot = aMod.type;
        CompoundTag cmp = new CompoundTag();
        mod.save((HolderLookup.Provider)level.registryAccess(), (Tag)cmp);
        mods.put(MOD_SLOT_KEY + slot, (Tag)cmp);
        TagsUtilDegradation.putTag(armor, tag);
    }

    public static void removeMod(ItemStack armor, int slot) {
        if (armor.isEmpty()) {
            return;
        }
        CompoundTag tag = TagsUtilDegradation.getTag(armor);
        if (!tag.contains(MOD_COMPOUND_KEY)) {
            tag.put(MOD_COMPOUND_KEY, (Tag)new CompoundTag());
        }
        CompoundTag mods = tag.getCompound(MOD_COMPOUND_KEY);
        mods.remove(MOD_SLOT_KEY + slot);
        if (mods.isEmpty()) {
            ArmorModHandler.clearMods(armor);
        }
        TagsUtilDegradation.putTag(armor, mods);
    }

    public static void clearMods(ItemStack armor) {
        if (!TagsUtilDegradation.containsAnyTag(armor)) {
            return;
        }
        CompoundTag tag = TagsUtilDegradation.getTag(armor);
        tag.remove(MOD_COMPOUND_KEY);
        TagsUtilDegradation.putTag(armor, tag);
    }

    public static boolean hasMods(ItemStack armor) {
        if (!TagsUtilDegradation.containsAnyTag(armor)) {
            return false;
        }
        CompoundTag tag = TagsUtilDegradation.getTag(armor);
        return tag.contains(MOD_COMPOUND_KEY);
    }

    public static ItemStack[] pryMods(Level level, ItemStack armor) {
        ItemStack[] slots = new ItemStack[9];
        if (!ArmorModHandler.hasMods(armor)) {
            return slots;
        }
        CompoundTag tag = TagsUtilDegradation.getTag(armor);
        CompoundTag mods = tag.getCompound(MOD_COMPOUND_KEY);
        for (int i = 0; i < 9; ++i) {
            CompoundTag cmp = mods.getCompound(MOD_SLOT_KEY + i);
            Optional stack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)cmp);
            if (stack.isPresent() && !((ItemStack)stack.get()).isEmpty()) {
                slots[i] = (ItemStack)stack.get();
                continue;
            }
            ArmorModHandler.removeMod(armor, i);
        }
        return slots;
    }

    public static ItemStack pryMod(Level level, ItemStack armor, int slot) {
        if (!ArmorModHandler.hasMods(armor)) {
            return ItemStack.EMPTY;
        }
        CompoundTag nbt = TagsUtilDegradation.getTag(armor);
        CompoundTag mods = nbt.getCompound(MOD_COMPOUND_KEY);
        CompoundTag cmp = mods.getCompound(MOD_SLOT_KEY + slot);
        Optional stack = ItemStack.parse((HolderLookup.Provider)level.registryAccess(), (Tag)cmp);
        if (stack.isPresent() && !((ItemStack)stack.get()).isEmpty()) {
            return (ItemStack)stack.get();
        }
        ArmorModHandler.removeMod(armor, slot);
        return ItemStack.EMPTY;
    }
}

