/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.HBMsNTMClient;
import com.hbm.config.MainConfig;
import com.hbm.extprop.HbmLivingAttachments;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.lib.ModDamageSource;
import com.hbm.lib.ModSounds;
import com.hbm.network.toclient.AuxParticle;
import com.hbm.util.ContaminationUtil;
import com.hbm.world.biome.ModBiomes;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class EntityEffectHandler {
    public static void tick(LivingEntity entity) {
        if (entity.tickCount % 20 == 0) {
            HbmLivingAttachments.setRadBuf(entity, HbmLivingAttachments.getRadEnv(entity));
            HbmLivingAttachments.setRadEnv(entity, 0.0f);
        }
        ResourceKey biome = entity.level().getBiome(new BlockPos((int)entity.getX(), (int)entity.getY(), (int)entity.getZ())).getKey();
        double radiation = 0.0;
        if (biome == ModBiomes.CRATER_OUTER) {
            radiation = (Double)MainConfig.COMMON.CRATER_OUTER_RAD.get();
        }
        if (biome == ModBiomes.CRATER) {
            radiation = (Double)MainConfig.COMMON.CRATER_RAD.get();
        }
        if (biome == ModBiomes.CRATER_INNER) {
            radiation = (Double)MainConfig.COMMON.CRATER_INNER_RAD.get();
        }
        if (entity.isInWater()) {
            radiation *= ((Double)MainConfig.COMMON.CRATER_WATER_MULT.get()).doubleValue();
        }
        if (radiation > 0.0) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, (float)radiation / 20.0f);
        }
        EntityEffectHandler.handleContamination(entity);
        EntityEffectHandler.handleRadiationEffect(entity);
        EntityEffectHandler.handleRadiationFX(entity);
        EntityEffectHandler.handleDigamma(entity);
        EntityEffectHandler.handleLungDisease(entity);
    }

    private static void handleContamination(LivingEntity entity) {
        if (entity.level().isClientSide) {
            return;
        }
        List<HbmLivingAttachments.ContaminationEffect> contamination = HbmLivingAttachments.getCont(entity);
        ArrayList<HbmLivingAttachments.ContaminationEffect> rem = new ArrayList<HbmLivingAttachments.ContaminationEffect>();
        for (HbmLivingAttachments.ContaminationEffect con : contamination) {
            ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, con.ignoreArmor ? ContaminationUtil.ContaminationType.RAD_BYPASS : ContaminationUtil.ContaminationType.CREATIVE, con.getRad());
            --con.time;
            if (con.time > 0) continue;
            rem.add(con);
        }
        contamination.removeAll(rem);
    }

    private static void handleRadiationEffect(LivingEntity entity) {
        Player player;
        if (!entity.isAlive()) {
            return;
        }
        if (entity.level().isClientSide) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).isCreative()) {
            return;
        }
        if (entity instanceof Player && (player = (Player)entity).isSpectator()) {
            return;
        }
        Level level = entity.level();
        float eRad = HbmLivingAttachments.getRadiation(entity);
        if (entity instanceof Cow && !(entity instanceof MushroomCow) && eRad >= 50.0f) {
            MushroomCow cow = new MushroomCow(EntityType.MOOSHROOM, level);
            cow.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
            level.addFreshEntity((Entity)cow);
            entity.discard();
        } else if (entity instanceof Villager && eRad >= 500.0f) {
            Zombie zombie = new Zombie(EntityType.ZOMBIE, level);
            zombie.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
            level.addFreshEntity((Entity)zombie);
            entity.discard();
        }
        if (eRad < 200.0f || ContaminationUtil.isRadImmune((Entity)entity)) {
            return;
        }
        if (eRad > 2500.0f) {
            HbmLivingAttachments.setRadiation(entity, 2500.0f);
        }
        if (eRad >= 1000.0f) {
            DamageSource src = new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(ModDamageSource.RADIATION));
            entity.hurt(src, Float.MAX_VALUE);
            HbmLivingAttachments.setRadiation(entity, 0.0f);
        } else if (eRad >= 800.0f) {
            if (level.random.nextInt(300) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 150, 0));
            }
            if (level.random.nextInt(300) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 2));
            }
            if (level.random.nextInt(300) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 2));
            }
            if (level.random.nextInt(500) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.POISON, 60, 2));
            }
            if (level.random.nextInt(700) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.WITHER, 60, 1));
            }
        } else if (eRad >= 600.0f) {
            if (level.random.nextInt(300) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 150, 0));
            }
            if (level.random.nextInt(300) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 2));
            }
            if (level.random.nextInt(300) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 2));
            }
            if (level.random.nextInt(500) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.POISON, 60, 1));
            }
        } else if (eRad >= 400.0f) {
            if (level.random.nextInt(300) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 150, 0));
            }
            if (level.random.nextInt(500) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 0));
            }
            if (level.random.nextInt(300) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 1));
            }
        } else if (eRad >= 200.0f) {
            if (level.random.nextInt(300) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0));
            }
            if (level.random.nextInt(500) == 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0));
            }
        }
    }

    private static void handleRadiationFX(LivingEntity entity) {
        Level level = entity.level();
        if (!level.isClientSide) {
            ServerLevel serverLevel;
            CompoundTag tag;
            Player player;
            if (ContaminationUtil.isRadImmune((Entity)entity)) {
                return;
            }
            float rad = ChunkRadiationManager.proxy.getRadiation(level, entity.blockPosition());
            if (level.dimension() == Level.NETHER && (Double)MainConfig.COMMON.HELL_RAD.get() > 0.0 && (double)rad < (Double)MainConfig.COMMON.HELL_RAD.get()) {
                rad = 0.01f;
            }
            if (rad > 0.0f) {
                ContaminationUtil.contaminate(entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, rad / 20.0f);
            }
            if (entity instanceof Player && (player = (Player)entity).isCreative()) {
                return;
            }
            if (entity instanceof Player && (player = (Player)entity).isSpectator()) {
                return;
            }
            Random rand = new Random(entity.getId());
            int r600 = rand.nextInt(600);
            int r1200 = rand.nextInt(1200);
            if (HbmLivingAttachments.getRadiation(entity) > 600.0f) {
                if ((level.getGameTime() + (long)r600) % 600L < 20L && EntityEffectHandler.canVomit((Entity)entity)) {
                    tag = new CompoundTag();
                    tag.putString("type", "vomit");
                    tag.putString("mode", "blood");
                    tag.putInt("count", 25);
                    tag.putInt("entity", entity.getId());
                    if (level instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (double)25.0, (CustomPacketPayload)new AuxParticle(tag, 0.0, 0.0, 0.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                    if ((level.getGameTime() + (long)r600) % 600L == 1L) {
                        level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), ModSounds.VOMIT, SoundSource.PLAYERS, 1.0f, 1.0f);
                        entity.addEffect(new MobEffectInstance(MobEffects.HUNGER, 60, 19));
                    }
                }
            } else if (HbmLivingAttachments.getRadiation(entity) > 200.0f && (level.getGameTime() + (long)r1200) % 1200L < 20L && EntityEffectHandler.canVomit((Entity)entity)) {
                tag = new CompoundTag();
                tag.putString("type", "vomit");
                tag.putString("mode", "normal");
                tag.putInt("count", 15);
                tag.putInt("entity", entity.getId());
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (double)25.0, (CustomPacketPayload)new AuxParticle(tag, 0.0, 0.0, 0.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                if ((level.getGameTime() + (long)r1200) % 1200L == 1L) {
                    level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), ModSounds.VOMIT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    entity.addEffect(new MobEffectInstance(MobEffects.HUNGER, 60, 19));
                }
            }
            if (HbmLivingAttachments.getRadiation(entity) > 900.0f && (level.getGameTime() + (long)rand.nextInt(10)) % 10L == 0L) {
                tag = new CompoundTag();
                tag.putString("type", "sweat");
                tag.putInt("count", 1);
                tag.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)Blocks.REDSTONE_BLOCK.defaultBlockState()));
                tag.putInt("entity", entity.getId());
                if (level instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (double)25.0, (CustomPacketPayload)new AuxParticle(tag, 0.0, 0.0, 0.0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        } else {
            float radiation = HbmLivingAttachments.getRadiation(entity);
            if (entity instanceof Player && radiation > 600.0f) {
                CompoundTag tag = new CompoundTag();
                tag.putString("type", "radiation");
                tag.putInt("count", radiation > 900.0f ? 4 : (radiation > 800.0f ? 2 : 1));
                HBMsNTMClient.effectNT(tag);
            }
        }
    }

    private static void handleDigamma(LivingEntity entity) {
        Level level = entity.level();
        if (!level.isClientSide) {
            float digamma = HbmLivingAttachments.getDigamma(entity);
            if (digamma < 0.1f) {
                return;
            }
            int chance = Math.max(10 - (int)digamma, 1);
            if (chance == 1 || entity.getRandom().nextInt(chance) == 0) {
                CompoundTag nbt = new CompoundTag();
                nbt.putString("type", "sweat");
                nbt.putInt("count", 1);
                nbt.put("BlockState", (Tag)NbtUtils.writeBlockState((BlockState)Blocks.SOUL_SAND.defaultBlockState()));
                nbt.putInt("entity", entity.getId());
                PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)level), null, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (double)25.0, (CustomPacketPayload)new AuxParticle(nbt, entity.getX(), entity.getY(), entity.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    private static void handleLungDisease(LivingEntity entity) {
        Level level = entity.level();
        if (!level.isClientSide) {
            boolean coughs;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.isCreative() || player.isSpectator()) {
                    HbmLivingAttachments.setBlackLung(entity, 0);
                    HbmLivingAttachments.setAsbestos(entity, 0);
                    return;
                }
                int bl = HbmLivingAttachments.getBlackLung(entity);
                if (bl > 0 && (double)bl < 72000.0) {
                    HbmLivingAttachments.setBlackLung(entity, HbmLivingAttachments.getBlackLung(entity) - 1);
                }
            }
            double blacklung = Math.min(HbmLivingAttachments.getBlackLung(entity), 144000);
            double asbestos = Math.min(HbmLivingAttachments.getAsbestos(entity), 72000);
            boolean bl = coughs = blacklung / 144000.0 > 0.25 || asbestos / 72000.0 > 0.25;
            if (!coughs) {
                return;
            }
            boolean coughsCoal = blacklung / 144000.0 > 0.5;
            boolean coughsALotOfCoal = blacklung / 144000.0 > 0.8;
            boolean coughsBlood = asbestos / 72000.0 > 0.75 || blacklung / 144000.0 > 0.75;
            double blacklungDelta = 1.0 - blacklung / 144000.0;
            double asbestosDelta = 1.0 - asbestos / 72000.0;
            double total = 1.0 - blacklungDelta * asbestosDelta;
            if (total > 0.75) {
                entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 2));
            }
            if (total > 0.95) {
                entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 100, 0));
            }
            total = 1.0 - blacklungDelta * asbestosDelta;
            int freq = Math.max((int)(1000.0 - 950.0 * total), 20);
            if (level.getGameTime() % (long)freq == (long)(entity.getId() % freq)) {
                ServerLevel serverLevel;
                CompoundTag tag;
                level.playSound(null, entity.getX(), entity.getY(), entity.getZ(), ModSounds.COUGH, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (coughsBlood) {
                    tag = new CompoundTag();
                    tag.putString("type", "vomit");
                    tag.putString("mode", "blood");
                    tag.putInt("count", 5);
                    tag.putInt("entity", entity.getId());
                    if (level instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (double)25.0, (CustomPacketPayload)new AuxParticle(tag, entity.getX(), entity.getY(), entity.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
                if (coughsCoal) {
                    tag = new CompoundTag();
                    tag.putString("type", "vomit");
                    tag.putString("mode", "smoke");
                    tag.putInt("count", coughsALotOfCoal ? 50 : 10);
                    tag.putInt("entity", entity.getId());
                    if (level instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)entity.getX(), (double)entity.getY(), (double)entity.getZ(), (double)25.0, (CustomPacketPayload)new AuxParticle(tag, entity.getX(), entity.getY(), entity.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                }
            }
        }
    }

    private static boolean canVomit(Entity entity) {
        return entity.getType().getCategory() != MobCategory.WATER_CREATURE;
    }
}

