/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.CommonEvents;
import com.hbm.handler.ArmorModHandler;
import com.hbm.items.ModItems;
import com.hbm.items.armor.ItemModCladding;
import com.hbm.lib.ModEffect;
import com.hbm.util.ShadyUtil;
import com.hbm.util.TagsUtilDegradation;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class HazmatRegistry {
    private static final HashMap<Item, Double> ENTRIES = new HashMap();
    public static final Gson gson = new Gson();

    public static void initDefault() {
        double helmet = 0.2;
        double chest = 0.4;
        double legs = 0.3;
        double boots = 0.1;
        double iron = 0.0225;
        double gold = 0.0225;
        double alloy = 0.07;
        HazmatRegistry.registerHazmat(Items.GOLDEN_HELMET, gold * helmet);
        HazmatRegistry.registerHazmat(Items.GOLDEN_CHESTPLATE, gold * chest);
        HazmatRegistry.registerHazmat(Items.GOLDEN_LEGGINGS, gold * legs);
        HazmatRegistry.registerHazmat(Items.GOLDEN_BOOTS, gold * boots);
        HazmatRegistry.registerHazmat(Items.IRON_HELMET, iron * helmet);
        HazmatRegistry.registerHazmat(Items.IRON_CHESTPLATE, iron * chest);
        HazmatRegistry.registerHazmat(Items.IRON_LEGGINGS, iron * legs);
        HazmatRegistry.registerHazmat(Items.IRON_BOOTS, iron * boots);
        HazmatRegistry.registerHazmat((Item)ModItems.ALLOY_HELMET.get(), alloy * helmet);
        HazmatRegistry.registerHazmat((Item)ModItems.ALLOY_CHESTPLATE.get(), alloy * chest);
        HazmatRegistry.registerHazmat((Item)ModItems.ALLOY_LEGGINGS.get(), alloy * legs);
        HazmatRegistry.registerHazmat((Item)ModItems.ALLOY_BOOTS.get(), alloy * boots);
    }

    private static void registerHazmat(Item item, double resistance) {
        ENTRIES.put(item, resistance);
    }

    public static void addInfo(List<Component> components, Level level, ItemStack stack) {
        double rad = (double)((int)(HazmatRegistry.getResistance(level, stack) * 1000.0)) / 1000.0;
        if (rad > 0.0) {
            components.add((Component)Component.translatable((String)"trait.radResistance", (Object[])new Object[]{rad}).withStyle(ChatFormatting.YELLOW));
        }
    }

    public static double getResistance(Level level, ItemStack stack) {
        if (stack.isEmpty()) {
            return 0.0;
        }
        double cladding = HazmatRegistry.getCladding(level, stack);
        Double f = ENTRIES.get(stack.getItem());
        if (f != null) {
            return f + cladding;
        }
        return cladding;
    }

    public static double getCladding(Level level, ItemStack stack) {
        Item item;
        ItemStack[] mods;
        ItemStack cladding;
        float claddingRes = TagsUtilDegradation.getTag(stack).getFloat("hfr_cladding");
        if (claddingRes > 0.0f) {
            return claddingRes;
        }
        if (ArmorModHandler.hasMods(stack) && !(cladding = (mods = ArmorModHandler.pryMods(level, stack))[5]).isEmpty() && (item = cladding.getItem()) instanceof ItemModCladding) {
            ItemModCladding modCladding = (ItemModCladding)item;
            return modCladding.rad;
        }
        return 0.0;
    }

    public static float getResistance(Player player) {
        float res = 0.0f;
        if (player.getUUID().toString().equals(ShadyUtil.Pu_238)) {
            res += 0.4f;
        }
        for (int i = 0; i < 4; ++i) {
            res += (float)HazmatRegistry.getResistance(player.level(), (ItemStack)player.getInventory().armor.get(i));
        }
        if (player.hasEffect(ModEffect.RADX)) {
            res += 0.2f;
        }
        return res;
    }

    public static void registerHazmats() {
        File folder = CommonEvents.configHbmDir;
        File config = new File(folder.getAbsolutePath() + File.separatorChar + "hbmRadResist.json");
        File template = new File(folder.getAbsolutePath() + File.separatorChar + "_hbmRadResist.json");
        HazmatRegistry.initDefault();
        if (!config.exists()) {
            HazmatRegistry.writeDefault(template);
        } else {
            HashMap<Item, Double> conf = HazmatRegistry.readConfig(config);
            if (conf != null) {
                ENTRIES.clear();
                ENTRIES.putAll(conf);
            }
        }
    }

    private static void writeDefault(File file) {
        try {
            JsonWriter writer = new JsonWriter((Writer)new FileWriter(file));
            writer.setIndent("  ");
            writer.beginObject();
            writer.name("comment").value("Template file, remove the underscore ('_') from the name to enable the config.");
            writer.name("entries").beginArray();
            for (Map.Entry<Item, Double> entry : ENTRIES.entrySet()) {
                writer.beginObject();
                writer.name("item").value(BuiltInRegistries.ITEM.getKey((Object)entry.getKey()).toString());
                writer.name("resistance").value((Number)entry.getValue());
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static HashMap<Item, Double> readConfig(File config) {
        try {
            JsonObject json = (JsonObject)gson.fromJson((Reader)new FileReader(config), JsonObject.class);
            JsonArray array = json.get("entries").getAsJsonArray();
            HashMap<Item, Double> conf = new HashMap<Item, Double>();
            for (JsonElement element : array) {
                JsonObject object = (JsonObject)element;
                Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)object.get("item").getAsString()));
                double resistance = object.get("resistance").getAsDouble();
                conf.put(item, resistance);
            }
            return conf;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

