/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.inventory.screens.CalculatorScreen;
import com.hbm.items.IKeybindReceiver;
import com.hbm.network.toserver.KeybindReceiver;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="hbmsntm", value={Dist.CLIENT})
public class KeyHandler {
    private static final String category = "hbmsntm.keys";
    public static final KeyMapping JETPACK = new KeyMapping("hbmsntm.keys.toggleBack", InputConstants.Type.KEYSYM, 67, "hbmsntm.keys");
    public static final KeyMapping MAGNET = new KeyMapping("hbmsntm.keys.toggleMagnet", InputConstants.Type.KEYSYM, 90, "hbmsntm.keys");
    public static final KeyMapping HUD = new KeyMapping("hbmsntm.keys.toggleHUD", InputConstants.Type.KEYSYM, 86, "hbmsntm.keys");
    public static final KeyMapping CALCULATOR = new KeyMapping("hbmsntm.keys.calc", InputConstants.Type.KEYSYM, 78, "hbmsntm.keys");
    public static final KeyMapping ABILITY_CYCLE = new KeyMapping("hbmsntm.keys.ability", InputConstants.Type.KEYSYM, 73, "hbmsntm.keys");
    public static final KeyMapping ABILITY_ALT = new KeyMapping("hbmsntm.keys.abilityAlt", InputConstants.Type.KEYSYM, 342, "hbmsntm.keys");
    private static final Map<KeyMapping, EnumKeybind> CONNECTED_BINDS = new HashMap<KeyMapping, EnumKeybind>();

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        KeyHandler.register(event, JETPACK, EnumKeybind.TOGGLE_JETPACK);
        KeyHandler.register(event, MAGNET, EnumKeybind.TOGGLE_MAGNET);
        KeyHandler.register(event, HUD, EnumKeybind.TOGGLE_HEAD);
        KeyHandler.register(event, ABILITY_CYCLE, EnumKeybind.ABILITY_CYCLE);
        KeyHandler.register(event, ABILITY_ALT, EnumKeybind.ABILITY_ALT);
    }

    private static void register(RegisterKeyMappingsEvent event, KeyMapping mapping, EnumKeybind logical) {
        event.register(mapping);
        CONNECTED_BINDS.put(mapping, logical);
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().screen != null) {
            return;
        }
        for (Map.Entry<KeyMapping, EnumKeybind> entry : CONNECTED_BINDS.entrySet()) {
            KeyMapping mapping = entry.getKey();
            EnumKeybind enumKeybind = entry.getValue();
            if (!mapping.matches(event.getButton(), event.getAction()) || event.getAction() != 1 && event.getAction() != 0) continue;
            boolean isPressed = event.getAction() == 1;
            PacketDistributor.sendToServer((CustomPacketPayload)new KeybindReceiver(enumKeybind, isPressed, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            KeyHandler.handleKeybindReceiver(Minecraft.getInstance().player, enumKeybind, isPressed);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().screen != null) {
            return;
        }
        for (Map.Entry<KeyMapping, EnumKeybind> entry : CONNECTED_BINDS.entrySet()) {
            KeyMapping mapping = entry.getKey();
            EnumKeybind enumKeybind = entry.getValue();
            if (!mapping.matches(event.getKey(), event.getScanCode()) || event.getAction() != 1 && event.getAction() != 0) continue;
            boolean isPressed = event.getAction() == 1;
            PacketDistributor.sendToServer((CustomPacketPayload)new KeybindReceiver(enumKeybind, isPressed, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            KeyHandler.handleKeybindReceiver(Minecraft.getInstance().player, enumKeybind, isPressed);
        }
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.screen != null) {
            return;
        }
        while (CALCULATOR.consumeClick()) {
            mc.setScreen((Screen)new CalculatorScreen());
        }
    }

    private static void handleKeybindReceiver(LocalPlayer player, EnumKeybind key, boolean state) {
        for (ItemStack stack : new ItemStack[]{player.getMainHandItem(), player.getOffhandItem()}) {
            IKeybindReceiver receiver;
            Item item = stack.getItem();
            if (!(item instanceof IKeybindReceiver) || !(receiver = (IKeybindReceiver)item).canHandleKeybind((Player)player, stack, key)) continue;
            receiver.handleKeybindClient(player, stack, key, state);
            PacketDistributor.sendToServer((CustomPacketPayload)new KeybindReceiver(key, state, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static enum EnumKeybind {
        JETPACK,
        TOGGLE_JETPACK,
        TOGGLE_MAGNET,
        TOGGLE_HEAD,
        DASH,
        TRAIN,
        CRANE_UP,
        CRANE_DOWN,
        CRANE_LEFT,
        CRANE_RIGHT,
        CRANE_LOAD,
        ABILITY_CYCLE,
        ABILITY_ALT,
        TOOL_ALT,
        TOOL_CTRL,
        GUN_PRIMARY,
        GUN_SECONDARY,
        GUN_TERTIARY,
        RELOAD;

    }
}

