/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ability;

import com.hbm.HBMsNTM;
import com.hbm.handler.ability.IBaseAbility;
import com.hbm.handler.ability.IToolAreaAbility;
import com.hbm.handler.ability.IToolHarvestAbility;
import com.hbm.handler.ability.IWeaponAbility;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class AvailableAbilities {
    private HashMap<IBaseAbility, Integer> abilities = new HashMap();

    public AvailableAbilities addAbility(IBaseAbility ability, int level) {
        if (level < 0 || level >= ability.levels()) {
            HBMsNTM.LOGGER.warn("Illegal level {} for ability {}", (Object)level, (Object)ability.getName());
            level = ability.levels() - 1;
        }
        if (this.abilities.containsKey(ability)) {
            HBMsNTM.LOGGER.warn("Ability {} already had level {}, overwriting with level {}", new Object[]{ability.getName(), this.abilities.get(ability), level});
        }
        this.abilities.put(ability, level);
        return this;
    }

    public AvailableAbilities addToolAbilities() {
        this.addAbility(IToolAreaAbility.NONE, 0);
        this.addAbility(IToolHarvestAbility.NONE, 0);
        return this;
    }

    public AvailableAbilities removeAbility(IBaseAbility ability) {
        this.abilities.remove(ability);
        return this;
    }

    public boolean supportsAbility(IBaseAbility ability) {
        return this.abilities.containsKey(ability);
    }

    public int maxLevel(IBaseAbility ability) {
        return this.abilities.getOrDefault(ability, -1);
    }

    public Map<IBaseAbility, Integer> get() {
        return Collections.unmodifiableMap(this.abilities);
    }

    public Map<IWeaponAbility, Integer> getWeaponAbilities() {
        return this.abilities.keySet().stream().filter(a -> a instanceof IWeaponAbility).collect(Collectors.toMap(a -> (IWeaponAbility)a, a -> this.abilities.get(a)));
    }

    public Map<IBaseAbility, Integer> getToolAbilities() {
        return this.abilities.keySet().stream().filter(a -> a instanceof IToolAreaAbility || a instanceof IToolHarvestAbility).collect(Collectors.toMap(a -> a, a -> this.abilities.get(a)));
    }

    public Map<IToolAreaAbility, Integer> getToolAreaAbilities() {
        return this.abilities.keySet().stream().filter(a -> a instanceof IToolAreaAbility).collect(Collectors.toMap(a -> (IToolAreaAbility)a, a -> this.abilities.get(a)));
    }

    public Map<IToolHarvestAbility, Integer> getToolHarvestAbilities() {
        return this.abilities.keySet().stream().filter(a -> a instanceof IToolHarvestAbility).collect(Collectors.toMap(a -> (IToolHarvestAbility)a, a -> this.abilities.get(a)));
    }

    public int size() {
        return this.abilities.size();
    }

    public boolean isEmpty() {
        return this.abilities.isEmpty();
    }

    public void appendHoverText(List<Component> list) {
        List<Map.Entry> weaponAbilities;
        List<Map.Entry> toolAbilities = this.abilities.entrySet().stream().filter(entry -> entry.getKey() instanceof IToolAreaAbility && entry.getKey() != IToolAreaAbility.NONE || entry.getKey() instanceof IToolHarvestAbility && entry.getKey() != IToolHarvestAbility.NONE).sorted(Comparator.comparing(Map.Entry::getKey).thenComparing(Map.Entry::getValue)).toList();
        if (!toolAbilities.isEmpty()) {
            list.add((Component)Component.translatable((String)"tool.ability.tooltip").withStyle(ChatFormatting.GRAY));
            toolAbilities.forEach(entry -> {
                IBaseAbility ability = (IBaseAbility)entry.getKey();
                int level = (Integer)entry.getValue();
                list.add((Component)Component.literal((String)("  " + ability.getFullName(level))).withStyle(ChatFormatting.GOLD));
            });
            list.add((Component)Component.translatable((String)"tool.ability.tooltip.cycle").withStyle(ChatFormatting.GRAY));
            list.add((Component)Component.translatable((String)"tool.ability.tooltip.sneak").withStyle(ChatFormatting.GRAY));
            list.add((Component)Component.translatable((String)"tool.ability.tooltip.gui").withStyle(ChatFormatting.GRAY));
        }
        if (!(weaponAbilities = this.abilities.entrySet().stream().filter(entry -> entry.getKey() instanceof IWeaponAbility && entry.getKey() != IWeaponAbility.NONE).sorted(Comparator.comparing(Map.Entry::getKey).thenComparing(Map.Entry::getValue)).toList()).isEmpty()) {
            list.add((Component)Component.translatable((String)"tool.ability.tooltip.weapon").withStyle(ChatFormatting.GRAY));
            weaponAbilities.forEach(entry -> {
                IBaseAbility ability = (IBaseAbility)entry.getKey();
                int level = (Integer)entry.getValue();
                list.add((Component)Component.literal((String)("  " + ability.getFullName(level))).withStyle(ChatFormatting.RED));
            });
        }
    }
}

