/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ability;

import com.hbm.config.MainConfig;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.handler.ability.IBaseAbility;
import com.hbm.items.tools.ToolAbilityItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface IToolAreaAbility
extends IBaseAbility {
    public static final int SORT_ORDER_BASE = 0;
    public static final IToolAreaAbility NONE = new IToolAreaAbility(){

        @Override
        public String getName() {
            return "";
        }

        @Override
        public int sortOrder() {
            return 0;
        }

        @Override
        public boolean onDig(int lvl, Level level, BlockPos pos, Player player, ToolAbilityItem tool) {
            return false;
        }
    };
    public static final IToolAreaAbility RECURSION = new IToolAreaAbility(){
        public final int[] radiusAtLevel = new int[]{3, 4, 5, 6, 7, 9, 10};
        private Set<BlockPos> posSet = new HashSet<BlockPos>();
        private final List<BlockPos> offsets = new ArrayList<BlockPos>(26){
            {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dy = -1; dy <= 1; ++dy) {
                        for (int dz = -1; dz <= 1; ++dz) {
                            if (dx == 0 && dy == 0 && dz == 0) continue;
                            this.add(new BlockPos(dx, dy, dz));
                        }
                    }
                }
            }
        };

        @Override
        public String getName() {
            return "tool.ability.recursion";
        }

        @Override
        public boolean isAllowed() {
            return (Boolean)MainConfig.COMMON.ABILITY_VEIN.get();
        }

        @Override
        public int levels() {
            return this.radiusAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.radiusAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 1;
        }

        @Override
        public boolean onDig(int lvl, Level level, BlockPos pos, Player player, ToolAbilityItem tool) {
            BlockState state = level.getBlockState(pos);
            if (state.is(Blocks.STONE) && !((Boolean)MainConfig.COMMON.RECURSION_STONE.get()).booleanValue()) {
                return false;
            }
            if (state.is(Blocks.NETHERRACK) && !((Boolean)MainConfig.COMMON.RECURSION_NETHERRACK.get()).booleanValue()) {
                return false;
            }
            this.posSet.clear();
            this.recurse(level, pos, pos, player, tool, 0, this.radiusAtLevel[lvl]);
            return false;
        }

        private void recurse(Level level, BlockPos pos, BlockPos ref, Player player, ToolAbilityItem tool, int depth, int radius) {
            ArrayList<BlockPos> shuffled = new ArrayList<BlockPos>(this.offsets);
            Collections.shuffle(shuffled);
            for (BlockPos offset : shuffled) {
                this.breakExtra(level, pos.offset((Vec3i)offset), ref, player, tool, depth, radius);
            }
        }

        private void breakExtra(Level level, BlockPos pos, BlockPos ref, Player player, ToolAbilityItem tool, int depth, int radius) {
            BlockState refState;
            if (!this.posSet.add(pos)) {
                return;
            }
            if (++depth > (Integer)MainConfig.COMMON.RECURSION_DEPTH.get()) {
                return;
            }
            if (pos.equals((Object)ref)) {
                return;
            }
            Vec3 delta = new Vec3((double)(pos.getX() - ref.getX()), (double)(pos.getY() - ref.getY()), (double)(pos.getZ() - ref.getZ()));
            if (delta.length() > (double)radius) {
                return;
            }
            BlockState state = level.getBlockState(pos);
            if (!this.isSameBlock(state, refState = level.getBlockState(ref))) {
                return;
            }
            if (player.getMainHandItem().isEmpty()) {
                return;
            }
            tool.breakExtraBlock(level, pos, player, ref);
            this.recurse(level, pos, ref, player, tool, depth, radius);
        }

        private boolean isSameBlock(BlockState blockStateA, BlockState blockStateB) {
            return blockStateA.is(blockStateB.getBlock());
        }
    };
    public static final IToolAreaAbility HAMMER = new IToolAreaAbility(){
        public final int[] rangeAtLevel = new int[]{1, 2, 3, 4};

        @Override
        public String getName() {
            return "tool.ability.hammer";
        }

        @Override
        public boolean isAllowed() {
            return (Boolean)MainConfig.COMMON.ABILITY_HAMMER.get();
        }

        @Override
        public int levels() {
            return this.rangeAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.rangeAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 2;
        }

        @Override
        public boolean onDig(int lvl, Level level, BlockPos pos, Player player, ToolAbilityItem tool) {
            int range = this.rangeAtLevel[lvl];
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            for (int a = x - range; a <= x + range; ++a) {
                for (int b = y - range; b <= y + range; ++b) {
                    for (int c = z - range; c <= z + range; ++c) {
                        if (a == x && b == y && c == z) continue;
                        tool.breakExtraBlock(level, new BlockPos(a, b, c), player, pos);
                    }
                }
            }
            return false;
        }
    };
    public static final IToolAreaAbility HAMMER_FLAT = new IToolAreaAbility(){
        public final int[] rangeAtLevel = new int[]{1, 2, 3, 4};

        @Override
        public String getName() {
            return "tool.ability.hammer_flat";
        }

        @Override
        public boolean isAllowed() {
            return (Boolean)MainConfig.COMMON.ABILITY_HAMMER.get();
        }

        @Override
        public int levels() {
            return this.rangeAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.rangeAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 3;
        }

        @Override
        public boolean onDig(int lvl, Level level, BlockPos pos, Player player, ToolAbilityItem tool) {
            int range = this.rangeAtLevel[lvl];
            HitResult hit = this.raytraceFromEntity(level, player, false, 4.5);
            if (hit.getType() != HitResult.Type.BLOCK) {
                return true;
            }
            BlockHitResult blockHit = (BlockHitResult)hit;
            Direction sideHit = blockHit.getDirection();
            int xRange = range;
            int yRange = range;
            int zRange = switch (sideHit) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN, Direction.UP -> {
                    yRange = 0;
                    yield range;
                }
                case Direction.NORTH, Direction.SOUTH -> 0;
                case Direction.WEST, Direction.EAST -> {
                    xRange = 0;
                    yield range;
                }
            };
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            for (int a = x - xRange; a <= x + xRange; ++a) {
                for (int b = y - yRange; b <= y + yRange; ++b) {
                    for (int c = z - zRange; c <= z + zRange; ++c) {
                        if (a == x && b == y && c == z) continue;
                        tool.breakExtraBlock(level, new BlockPos(a, b, c), player, pos);
                    }
                }
            }
            return false;
        }

        private HitResult raytraceFromEntity(Level level, Player player, boolean includeLiquids, double range) {
            Vec3 eyePos = player.getEyePosition(1.0f);
            Vec3 lookVec = player.getViewVector(1.0f);
            Vec3 targetPos = eyePos.add(lookVec.scale(range));
            ClipContext.Fluid fluidMode = includeLiquids ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE;
            ClipContext context = new ClipContext(eyePos, targetPos, ClipContext.Block.COLLIDER, fluidMode, (Entity)player);
            return level.clip(context);
        }
    };
    public static final IToolAreaAbility EXPLOSION = new IToolAreaAbility(){
        public final float[] strengthAtLevel = new float[]{2.5f, 5.0f, 10.0f, 15.0f};

        @Override
        public String getName() {
            return "tool.ability.explosion";
        }

        @Override
        public boolean isAllowed() {
            return (Boolean)MainConfig.COMMON.ABILITY_EXPLOSION.get();
        }

        @Override
        public int levels() {
            return this.strengthAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.strengthAtLevel[level] + ")";
        }

        @Override
        public boolean allowsHarvest(int level) {
            return false;
        }

        @Override
        public int sortOrder() {
            return 4;
        }

        @Override
        public boolean onDig(int lvl, Level level, BlockPos pos, Player player, ToolAbilityItem tool) {
            float strength = this.strengthAtLevel[lvl];
            ExplosionVNT vnt = new ExplosionVNT(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, strength);
            vnt.setBlockAllocator(new BlockAllocatorStandard());
            vnt.setBlockProcessor(new BlockProcessorStandard().setAllDrop());
            vnt.explode();
            level.explode((Entity)player, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.1f, Level.ExplosionInteraction.NONE);
            return true;
        }
    };
    public static final IToolAreaAbility[] abilities = new IToolAreaAbility[]{NONE, RECURSION, HAMMER, HAMMER_FLAT, EXPLOSION};

    public boolean onDig(int var1, Level var2, BlockPos var3, Player var4, ToolAbilityItem var5);

    default public boolean allowsHarvest(int lvl) {
        return true;
    }

    public static IToolAreaAbility getByName(String name) {
        for (IToolAreaAbility ability : abilities) {
            if (!ability.getName().equals(name)) continue;
            return ability;
        }
        return NONE;
    }
}

