/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ability;

import com.hbm.config.MainConfig;
import com.hbm.handler.ability.IBaseAbility;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IToolHarvestAbility
extends IBaseAbility {
    public static final int SORT_ORDER_BASE = 100;
    public static final IToolHarvestAbility NONE = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "";
        }

        @Override
        public int sortOrder() {
            return 100;
        }
    };
    public static final IToolHarvestAbility SILK = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.silktouch";
        }

        @Override
        public boolean isAllowed() {
            return (Boolean)MainConfig.COMMON.ABILITY_SILK.get();
        }

        @Override
        public int sortOrder() {
            return 101;
        }

        @Override
        public void preHarvestAll(int lvl, Level level, Player player, ItemStack tool) {
            Holder.Reference silkTouch = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH);
            if (!tool.isEmpty()) {
                EnchantmentHelper.updateEnchantments((ItemStack)tool, arg_0 -> 2.lambda$preHarvestAll$0((Holder)silkTouch, arg_0));
            }
        }

        @Override
        public void postHarvestAll(int lvl, Level level, Player player, ItemStack tool) {
            Holder.Reference silkTouch = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH);
            if (!tool.isEmpty()) {
                EnchantmentHelper.updateEnchantments((ItemStack)tool, arg_0 -> 2.lambda$postHarvestAll$1((Holder)silkTouch, arg_0));
            }
        }

        private static /* synthetic */ void lambda$postHarvestAll$1(Holder silkTouch, ItemEnchantments.Mutable mutable) {
            mutable.set(silkTouch, 0);
        }

        private static /* synthetic */ void lambda$preHarvestAll$0(Holder silkTouch, ItemEnchantments.Mutable mutable) {
            mutable.set(silkTouch, 1);
        }
    };
    public static final IToolHarvestAbility LUCK = new IToolHarvestAbility(){
        public final int[] powerAtLevel = new int[]{1, 2, 3, 4, 5, 9};

        @Override
        public String getName() {
            return "tool.ability.luck";
        }

        @Override
        public boolean isAllowed() {
            return (Boolean)MainConfig.COMMON.ABILITY_LUCK.get();
        }

        @Override
        public int levels() {
            return this.powerAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.powerAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 102;
        }

        @Override
        public void preHarvestAll(int lvl, Level level, Player player, ItemStack tool) {
            Holder.Reference fortune = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE);
            if (!tool.isEmpty()) {
                EnchantmentHelper.updateEnchantments((ItemStack)tool, arg_0 -> 3.lambda$preHarvestAll$0((Holder)fortune, arg_0));
            }
        }

        @Override
        public void postHarvestAll(int lvl, Level level, Player player, ItemStack tool) {
            Holder.Reference fortune = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE);
            if (!tool.isEmpty()) {
                EnchantmentHelper.updateEnchantments((ItemStack)tool, arg_0 -> 3.lambda$postHarvestAll$1((Holder)fortune, arg_0));
            }
        }

        private static /* synthetic */ void lambda$postHarvestAll$1(Holder fortune, ItemEnchantments.Mutable mutable) {
            mutable.set(fortune, 0);
        }

        private static /* synthetic */ void lambda$preHarvestAll$0(Holder fortune, ItemEnchantments.Mutable mutable) {
            mutable.set(fortune, 1);
        }
    };
    public static final IToolHarvestAbility SMELTER = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.smelter";
        }

        @Override
        public int sortOrder() {
            return 103;
        }
    };
    public static final IToolHarvestAbility SHREDDER = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.shredder";
        }

        @Override
        public int sortOrder() {
            return 104;
        }
    };
    public static final IToolHarvestAbility CENTRIFUGE = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.centrifuge";
        }

        @Override
        public int sortOrder() {
            return 105;
        }
    };
    public static final IToolHarvestAbility CRYSTALLIZER = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.crystallizer";
        }

        @Override
        public int sortOrder() {
            return 106;
        }
    };
    public static final IToolHarvestAbility MERCURY = new IToolHarvestAbility(){

        @Override
        public String getName() {
            return "tool.ability.mercury";
        }

        @Override
        public int sortOrder() {
            return 107;
        }
    };
    public static final IToolHarvestAbility[] abilities = new IToolHarvestAbility[]{NONE, SILK, LUCK, SMELTER, SHREDDER, CENTRIFUGE, CRYSTALLIZER, MERCURY};

    default public void preHarvestAll(int lvl, Level level, Player player, ItemStack tool) {
    }

    default public void postHarvestAll(int lvl, Level level, Player player, ItemStack tool) {
    }

    default public void onHarvestBlock(Level level, BlockPos pos, Player player, BlockPos refPos) {
        BlockState refState;
        BlockState state = level.getBlockState(pos);
        if (state.is((refState = level.getBlockState(refPos)).getBlock())) {
            List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)player.getMainHandItem());
            for (ItemStack stack : drops) {
                if (stack.isEmpty()) continue;
                Block.popResource((Level)level, (BlockPos)refPos, (ItemStack)stack);
            }
            level.removeBlock(pos, false);
            player.getMainHandItem().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
    }

    public static IToolHarvestAbility getByName(String name) {
        for (IToolHarvestAbility ability : abilities) {
            if (!ability.getName().equals(name)) continue;
            return ability;
        }
        return NONE;
    }
}

