/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ability;

import com.hbm.handler.ability.IBaseAbility;
import com.hbm.util.ContaminationUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public interface IWeaponAbility
extends IBaseAbility {
    public static final int SORT_ORDER_BASE = 200;
    public static final IWeaponAbility NONE = new IWeaponAbility(){

        @Override
        public String getName() {
            return "";
        }

        @Override
        public int sortOrder() {
            return 200;
        }

        @Override
        public void onHit(int lvl, Level level, Player player, Entity victim, Item tool) {
        }
    };
    public static final IWeaponAbility RADIATION = new IWeaponAbility(){
        public final float[] radAtLevel = new float[]{15.0f, 50.0f, 500.0f};

        @Override
        public String getName() {
            return "weapon.ability.radiation";
        }

        @Override
        public int levels() {
            return this.radAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.radAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 201;
        }

        @Override
        public void onHit(int lvl, Level level, Player player, Entity victim, Item tool) {
            if (victim instanceof LivingEntity) {
                LivingEntity livingVictim = (LivingEntity)victim;
                ContaminationUtil.contaminate(livingVictim, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, this.radAtLevel[lvl]);
            }
        }
    };
    public static final IWeaponAbility VAMPIRE = new IWeaponAbility(){
        public final float[] amountAtLevel = new float[]{2.0f, 3.0f, 5.0f, 10.0f, 50.0f};

        @Override
        public String getName() {
            return "weapon.ability.vampire";
        }

        @Override
        public int levels() {
            return this.amountAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.amountAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 202;
        }

        @Override
        public void onHit(int lvl, Level level, Player player, Entity victim, Item tool) {
            float amount = this.amountAtLevel[lvl];
            if (victim instanceof LivingEntity) {
                LivingEntity livingVictim = (LivingEntity)victim;
                if (livingVictim.getHealth() <= 0.0f) {
                    return;
                }
                livingVictim.setHealth(livingVictim.getHealth() - amount);
                if (livingVictim.getHealth() <= 0.0f) {
                    livingVictim.die(new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.MAGIC)));
                }
                player.heal(amount);
            }
        }
    };
    public static final IWeaponAbility STUN = new IWeaponAbility(){
        public final int[] durationAtLevel = new int[]{2, 3, 5, 10, 15};

        @Override
        public String getName() {
            return "weapon.ability.stun";
        }

        @Override
        public int levels() {
            return this.durationAtLevel.length;
        }

        @Override
        public String getExtension(int level) {
            return " (" + this.durationAtLevel[level] + ")";
        }

        @Override
        public int sortOrder() {
            return 203;
        }

        @Override
        public void onHit(int lvl, Level level, Player player, Entity victim, Item tool) {
            int duration = this.durationAtLevel[lvl];
            if (victim instanceof LivingEntity) {
                LivingEntity livingVictim = (LivingEntity)victim;
                livingVictim.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration * 20, 4));
                livingVictim.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, duration * 20, 4));
            }
        }
    };
    public static final IWeaponAbility BEHEADER = new IWeaponAbility(){

        @Override
        public String getName() {
            return "weapon.ability.beheader";
        }

        @Override
        public int sortOrder() {
            return 208;
        }

        @Override
        public void onHit(int level, Level world, Player player, Entity victim, Item tool) {
            LivingEntity living;
            if (victim instanceof LivingEntity && (living = (LivingEntity)victim).getHealth() <= 0.0f) {
                LivingEntity livingEntity = living;
                Objects.requireNonNull(livingEntity);
                LivingEntity livingEntity2 = livingEntity;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Skeleton.class, WitherSkeleton.class, Zombie.class, Creeper.class, MagmaCube.class, Slime.class, Player.class}, (Object)livingEntity2, n)) {
                    case 0: {
                        Skeleton ignored = (Skeleton)livingEntity2;
                        living.spawnAtLocation(new ItemStack((ItemLike)Items.SKELETON_SKULL), 0.0f);
                        break;
                    }
                    case 1: {
                        WitherSkeleton ignored = (WitherSkeleton)livingEntity2;
                        if (world.random.nextInt(20) == 0) {
                            living.spawnAtLocation(new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL), 0.0f);
                            break;
                        }
                        living.spawnAtLocation(new ItemStack((ItemLike)Items.COAL, 3), 0.0f);
                        break;
                    }
                    case 2: {
                        Zombie ignored = (Zombie)livingEntity2;
                        living.spawnAtLocation(new ItemStack((ItemLike)Items.ZOMBIE_HEAD), 0.0f);
                        break;
                    }
                    case 3: {
                        Creeper ignored = (Creeper)livingEntity2;
                        living.spawnAtLocation(new ItemStack((ItemLike)Items.CREEPER_HEAD), 0.0f);
                        break;
                    }
                    case 4: {
                        MagmaCube ignored = (MagmaCube)livingEntity2;
                        living.spawnAtLocation(new ItemStack((ItemLike)Items.MAGMA_CREAM, 3), 0.0f);
                        break;
                    }
                    case 5: {
                        Slime ignored = (Slime)livingEntity2;
                        living.spawnAtLocation(new ItemStack((ItemLike)Items.SLIME_BALL, 3), 0.0f);
                        break;
                    }
                    case 6: {
                        Player targetPlayer = (Player)livingEntity2;
                        ItemStack head = new ItemStack((ItemLike)Items.PLAYER_HEAD);
                        head.set(DataComponents.PROFILE, (Object)new ResolvableProfile(targetPlayer.getGameProfile()));
                        living.spawnAtLocation(head, 0.0f);
                        break;
                    }
                    default: {
                        living.spawnAtLocation(new ItemStack((ItemLike)Items.ROTTEN_FLESH, 3), 0.0f);
                        living.spawnAtLocation(new ItemStack((ItemLike)Items.BONE, 2), 0.0f);
                    }
                }
            }
        }
    };
    public static final IWeaponAbility[] abilities = new IWeaponAbility[]{NONE, RADIATION, VAMPIRE, STUN, BEHEADER};

    public void onHit(int var1, Level var2, Player var3, Entity var4, Item var5);

    public static IWeaponAbility getByName(String name) {
        for (IWeaponAbility ability : abilities) {
            if (!ability.getName().equals(name)) continue;
            return ability;
        }
        return NONE;
    }
}

