/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.ability;

import com.hbm.handler.ability.AvailableAbilities;
import com.hbm.handler.ability.IToolAreaAbility;
import com.hbm.handler.ability.IToolHarvestAbility;
import com.hbm.util.ChatBuilder;
import com.hbm.util.i18n.I18nUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class ToolPreset {
    public IToolAreaAbility areaAbility = IToolAreaAbility.NONE;
    public int areaAbilityLevel = 0;
    public IToolHarvestAbility harvestAbility = IToolHarvestAbility.NONE;
    public int harvestAbilityLevel = 0;

    public ToolPreset() {
    }

    public ToolPreset(IToolAreaAbility areaAbility, IToolHarvestAbility harvestAbility) {
        this.areaAbility = areaAbility;
        this.harvestAbility = harvestAbility;
    }

    public ToolPreset(IToolAreaAbility areaAbility, int areaAbilityLevel, IToolHarvestAbility harvestAbility, int harvestAbilityLevel) {
        this.areaAbility = areaAbility;
        this.areaAbilityLevel = areaAbilityLevel;
        this.harvestAbility = harvestAbility;
        this.harvestAbilityLevel = harvestAbilityLevel;
    }

    public String toString() {
        return "ToolPreset {areaAbility=" + I18nUtil.resolveKey(this.areaAbility.getName(), new Object[0]) + ", areaAbilityLevel=" + this.areaAbilityLevel + ", harvestAbility=" + I18nUtil.resolveKey(this.harvestAbility.getName(), new Object[0]) + ", harvestAbilityLevel=" + this.harvestAbilityLevel + "}";
    }

    public Component getMessage() {
        if (this.isNone()) {
            return ChatBuilder.start("[Tool ability deactivated]").color(ChatFormatting.GOLD).flush();
        }
        boolean hasArea = this.areaAbility != IToolAreaAbility.NONE;
        boolean hasHarvest = this.harvestAbility != IToolHarvestAbility.NONE;
        ChatBuilder builder = ChatBuilder.start("[Enabled ");
        if (hasArea) {
            builder.nextTranslation(this.areaAbility.getName(), new Object[0]);
            builder.next(this.areaAbility.getExtension(this.areaAbilityLevel));
        }
        if (hasArea && hasHarvest) {
            builder.next(" + ");
        }
        if (hasHarvest) {
            builder.nextTranslation(this.harvestAbility.getName(), new Object[0]);
            builder.next(this.harvestAbility.getExtension(this.harvestAbilityLevel));
        }
        return builder.next("]").colorAll(ChatFormatting.YELLOW).flush();
    }

    public boolean isNone() {
        return this.areaAbility == IToolAreaAbility.NONE && this.harvestAbility == IToolHarvestAbility.NONE;
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.putString("area", this.areaAbility.getName());
        nbt.putInt("areaLevel", this.areaAbilityLevel);
        nbt.putString("harvest", this.harvestAbility.getName());
        nbt.putInt("harvestLevel", this.harvestAbilityLevel);
    }

    public void readFromNBT(CompoundTag nbt) {
        this.areaAbility = IToolAreaAbility.getByName(nbt.getString("area"));
        this.areaAbilityLevel = nbt.getInt("areaLevel");
        this.harvestAbility = IToolHarvestAbility.getByName(nbt.getString("harvest"));
        this.harvestAbilityLevel = nbt.getInt("harvestLevel");
        this.areaAbilityLevel = Math.min(this.areaAbilityLevel, this.areaAbility.levels() - 1);
        this.harvestAbilityLevel = Math.min(this.harvestAbilityLevel, this.harvestAbility.levels() - 1);
    }

    public void restrictTo(AvailableAbilities availableAbilities) {
        int maxHarvestLevel;
        int maxAreaLevel = availableAbilities.maxLevel(this.areaAbility);
        if (maxAreaLevel == -1) {
            this.areaAbility = IToolAreaAbility.NONE;
            this.areaAbilityLevel = 0;
        } else if (this.areaAbilityLevel > maxAreaLevel) {
            this.areaAbilityLevel = maxAreaLevel;
        } else if (this.areaAbilityLevel < 0) {
            this.areaAbilityLevel = 0;
        }
        if (!this.areaAbility.allowsHarvest(this.areaAbilityLevel)) {
            this.harvestAbility = IToolHarvestAbility.NONE;
            this.harvestAbilityLevel = 0;
        }
        if ((maxHarvestLevel = availableAbilities.maxLevel(this.harvestAbility)) == -1) {
            this.harvestAbility = IToolHarvestAbility.NONE;
            this.harvestAbilityLevel = 0;
        } else if (this.harvestAbilityLevel > maxHarvestLevel) {
            this.harvestAbilityLevel = maxHarvestLevel;
        } else if (this.harvestAbilityLevel < 0) {
            this.harvestAbilityLevel = 0;
        }
    }
}

