/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.radiation;

import com.hbm.config.MainConfig;
import com.hbm.handler.radiation.ChunkRadiationHandler;
import com.hbm.handler.radiation.ChunkRadiationHandlerSimple;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkDataEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="hbmsntm")
public class ChunkRadiationManager {
    public static final ChunkRadiationHandler proxy = new ChunkRadiationHandlerSimple();
    private static int eggTimer = 0;

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (!((Boolean)MainConfig.COMMON.ENABLE_CHUNK_RADS.get()).booleanValue()) {
            return;
        }
        proxy.receiveWorldLoad(event);
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (!((Boolean)MainConfig.COMMON.ENABLE_CHUNK_RADS.get()).booleanValue()) {
            return;
        }
        proxy.receiveWorldUnload(event);
    }

    @SubscribeEvent
    public static void onChunkDataLoad(ChunkDataEvent.Load event) {
        if (event.getLevel() == null) {
            return;
        }
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (!((Boolean)MainConfig.COMMON.ENABLE_CHUNK_RADS.get()).booleanValue()) {
            return;
        }
        proxy.receiveChunkLoad(event);
    }

    @SubscribeEvent
    public static void onChunkSave(ChunkDataEvent.Save event) {
        if (event.getLevel() == null) {
            return;
        }
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (!((Boolean)MainConfig.COMMON.ENABLE_CHUNK_RADS.get()).booleanValue()) {
            return;
        }
        proxy.receiveChunkSave(event);
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        if (!((Boolean)MainConfig.COMMON.ENABLE_CHUNK_RADS.get()).booleanValue()) {
            return;
        }
        proxy.receiveChunkUnload(event);
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        if (!((Boolean)MainConfig.COMMON.ENABLE_CHUNK_RADS.get()).booleanValue()) {
            return;
        }
        if (++eggTimer >= 20) {
            proxy.updateSystem();
            eggTimer = 0;
        }
        if (((Boolean)MainConfig.COMMON.WORLD_RAD_EFFECTS.get()).booleanValue()) {
            proxy.handleWorldDestruction();
        }
        proxy.receiveWorldTick((ServerTickEvent)event);
    }
}

