/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard;

import com.hbm.blocks.ModBlocks;
import com.hbm.hazard.HazardData;
import com.hbm.hazard.HazardSystem;
import com.hbm.hazard.type.HazardTypeAsbestos;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.hazard.type.HazardTypeBlinding;
import com.hbm.hazard.type.HazardTypeCoal;
import com.hbm.hazard.type.HazardTypeDigamma;
import com.hbm.hazard.type.HazardTypeExplosive;
import com.hbm.hazard.type.HazardTypeHot;
import com.hbm.hazard.type.HazardTypeHydroactive;
import com.hbm.hazard.type.HazardTypeRadiation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;

public class HazardRegistry {
    public static final HazardTypeBase RADIATION = new HazardTypeRadiation();
    public static final HazardTypeBase DIGAMMA = new HazardTypeDigamma();
    public static final HazardTypeBase HOT = new HazardTypeHot();
    public static final HazardTypeBase BLINDING = new HazardTypeBlinding();
    public static final HazardTypeBase ASBESTOS = new HazardTypeAsbestos();
    public static final HazardTypeBase COAL = new HazardTypeCoal();
    public static final HazardTypeBase HYDROACTIVE = new HazardTypeHydroactive();
    public static final HazardTypeBase EXPLOSIVE = new HazardTypeExplosive();

    public static void registerItems() {
        HazardSystem.register(Items.GUNPOWDER, HazardRegistry.makeData(EXPLOSIVE, 1.0f));
        HazardSystem.register(Items.PUMPKIN_PIE, HazardRegistry.makeData(EXPLOSIVE, 1.0f));
        HazardSystem.register(Blocks.TNT, HazardRegistry.makeData(EXPLOSIVE, 4.0f));
        HazardSystem.register(Items.GOLD_INGOT, HazardRegistry.makeData(BLINDING, 4.0f));
        HazardSystem.register(Items.BLAZE_POWDER, HazardRegistry.makeData(HOT, 4.0f));
        HazardSystem.register(Blocks.GREEN_WOOL, HazardRegistry.makeData(RADIATION, 150.0f));
        HazardSystem.register(Blocks.WHITE_WOOL, HazardRegistry.makeData(ASBESTOS, 5.0f));
        HazardSystem.register(Items.COAL, HazardRegistry.makeData(COAL, 1.0f));
        HazardSystem.register(ModBlocks.URANIUM_BLOCK.get(), HazardRegistry.makeData(RADIATION, 160.0f));
    }

    private static HazardData makeData() {
        return new HazardData();
    }

    private static HazardData makeData(HazardTypeBase hazard) {
        return new HazardData().addEntry(hazard);
    }

    private static HazardData makeData(HazardTypeBase hazard, float level) {
        return new HazardData().addEntry(hazard, level);
    }

    private static HazardData makeData(HazardTypeBase hazard, float level, boolean override) {
        return new HazardData().addEntry(hazard, level, override);
    }
}

