/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard.type;

import com.hbm.config.MainConfig;
import com.hbm.hazard.modifier.HazardModifier;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.items.ModItems;
import com.hbm.util.BobMathUtil;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.i18n.I18nUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class HazardTypeRadiation
extends HazardTypeBase {
    @Override
    public void onUpdate(LivingEntity target, float level, ItemStack stack) {
        boolean reacher = false;
        if (target instanceof Player) {
            Player player = (Player)target;
            reacher = player.getInventory().contains(new ItemStack((ItemLike)ModItems.REACHER.get()));
        }
        if ((level *= (float)stack.getCount()) > 0.0f) {
            float rad = level / 20.0f;
            if (((Boolean)MainConfig.COMMON.ENABLE_528.get()).booleanValue() && reacher) {
                rad /= 49.0f;
            } else if (reacher) {
                rad = (float)BobMathUtil.squirt(rad);
            }
            ContaminationUtil.contaminate(target, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, rad);
        }
    }

    @Override
    public void updateEntity(ItemEntity item, float level) {
    }

    @Override
    public void addHazardInformation(Player player, List<Component> components, float level, ItemStack stack, List<HazardModifier> modifiers) {
        level = HazardModifier.evalAllModifiers(stack, (LivingEntity)player, level, modifiers);
        components.add((Component)Component.literal((String)("[" + I18nUtil.resolveKey("trait.radioactive", new Object[0]) + "]")).withStyle(ChatFormatting.GREEN));
        String rad = "" + Math.floor(level * 1000.0f) / 1000.0;
        components.add((Component)Component.literal((String)(rad + " RAD/s")).withStyle(ChatFormatting.YELLOW));
        if (stack.getCount() > 1) {
            double total = Math.floor(level * 1000.0f * (float)stack.getCount()) / 1000.0;
            components.add((Component)Component.literal((String)("Stack: " + total + " RAD/s")).withStyle(ChatFormatting.YELLOW));
        }
    }
}

