/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.HBMsNTM;
import com.hbm.config.MainConfig;
import com.hbm.items.ModItems;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RecipesCommon {
    public static ItemStack[] copyStackArray(ItemStack[] array) {
        if (array == null) {
            return null;
        }
        ItemStack[] clone = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            clone[i] = array[i].copy();
        }
        return clone;
    }

    public static ItemStack[] objectToStackArray(Object[] array) {
        if (array == null) {
            return null;
        }
        ItemStack[] clone = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] instanceof ItemStack)) continue;
            clone[i] = (ItemStack)array[i];
        }
        return clone;
    }

    public static class StateBlock {
        public final BlockState state;

        public StateBlock(BlockState state) {
            this.state = state;
        }

        public StateBlock(Block block) {
            this(block.defaultBlockState());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + BuiltInRegistries.BLOCK.getKey((Object)this.state.getBlock()).hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StateBlock other = (StateBlock)obj;
            return !(this.state == null ? other.state != null : !this.state.equals(other.state));
        }
    }

    public static class ComparableStack
    extends AStack {
        public Item item;

        public ComparableStack(ItemStack stack) {
            block4: {
                if (stack.isEmpty()) {
                    this.item = (Item)ModItems.NOTHING.get();
                    this.stackSize = 1;
                    return;
                }
                try {
                    this.item = stack.getItem();
                    if (this.item == null) {
                        ModItems.NOTHING.get();
                    }
                    this.stackSize = stack.getCount();
                }
                catch (Exception ex) {
                    this.item = (Item)ModItems.NOTHING.get();
                    if (((Boolean)MainConfig.COMMON.ENABLE_SILENT_COMPSTACK_ERRORS.get()).booleanValue()) break block4;
                    ex.printStackTrace();
                }
            }
        }

        public ComparableStack makeSingular() {
            this.stackSize = 1;
            return this;
        }

        public ComparableStack(Item item) {
            this.item = item;
            if (this.item == null) {
                this.item = (Item)ModItems.NOTHING.get();
            }
            this.stackSize = 1;
        }

        public ComparableStack(Block item) {
            this.item = item.asItem();
            this.stackSize = 1;
        }

        public ComparableStack(Block item, int stackSize) {
            this.item = item.asItem();
            this.stackSize = stackSize;
        }

        public ComparableStack(Item item, int stackSize) {
            this(item);
            this.stackSize = stackSize;
        }

        public ItemStack toStack() {
            return new ItemStack((ItemLike)(this.item == null ? (ItemLike)ModItems.NOTHING.get() : this.item), this.stackSize);
        }

        public int hashCode() {
            if (this.item == null) {
                if (!((Boolean)MainConfig.COMMON.ENABLE_SILENT_COMPSTACK_ERRORS.get()).booleanValue()) {
                    HBMsNTM.LOGGER.error("ComparableStack has a null item! This is a serious issue!");
                    Thread.dumpStack();
                }
                this.item = (Item)ModItems.NOTHING.get();
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + BuiltInRegistries.ITEM.getKey((Object)this.item).hashCode();
            result = 31 * result + this.stackSize;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComparableStack other = (ComparableStack)obj;
            if (this.item == null ? other.item != null : !this.item.equals(other.item)) {
                return false;
            }
            return this.stackSize == other.stackSize;
        }

        @Override
        public int compareTo(AStack stack) {
            if (stack instanceof ComparableStack) {
                ComparableStack comp = (ComparableStack)stack;
                int thisID = Item.getId((Item)this.item);
                int thatID = Item.getId((Item)comp.item);
                return Integer.compare(thisID, thatID);
            }
            return 0;
        }

        @Override
        public ComparableStack copy() {
            return new ComparableStack(this.item, this.stackSize);
        }

        @Override
        public ComparableStack copy(int stackSize) {
            return new ComparableStack(this.item, stackSize);
        }

        @Override
        public boolean matchesRecipe(ItemStack stack, boolean ignoreSize) {
            if (stack == null) {
                return false;
            }
            if (stack.getItem() != this.item) {
                return false;
            }
            return ignoreSize || stack.getCount() >= this.stackSize;
        }

        @Override
        public List<ItemStack> extractForJEI() {
            return Collections.singletonList(this.toStack());
        }
    }

    public static abstract class AStack
    implements Comparable<AStack> {
        protected int stackSize;

        public abstract boolean matchesRecipe(ItemStack var1, boolean var2);

        public abstract AStack copy();

        public abstract AStack copy(int var1);

        public abstract List<ItemStack> extractForJEI();

        public ItemStack extractForCyclingDisplay(int cycle) {
            List<ItemStack> list = this.extractForJEI();
            cycle *= 50;
            if (list.isEmpty()) {
                return new ItemStack((ItemLike)ModItems.NOTHING.get());
            }
            return list.get((int)(System.currentTimeMillis() % (long)(cycle * list.size()) / (long)cycle));
        }
    }
}

