/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.menus;

import com.hbm.blockentity.machine.MachineSatLinkerBlockEntity;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class MachineSatLinkerMenu
extends AbstractContainerMenu {
    private final MachineSatLinkerBlockEntity be;

    public MachineSatLinkerMenu(int id, Inventory playerInv, FriendlyByteBuf extraData) {
        this(id, playerInv, (MachineSatLinkerBlockEntity)playerInv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public MachineSatLinkerMenu(int id, Inventory playerInv, MachineSatLinkerBlockEntity be) {
        super((MenuType)ModMenuTypes.SAT_LINKER.get(), id);
        this.be = be;
        ItemStackHandler handler = be.getItems();
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 0, 44, 35));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 1, 80, 35));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 2, 116, 35));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)playerInv, x + y * 9 + 9, 8 + x * 18, 84 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)playerInv, x, 8 + x * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return MachineSatLinkerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)player.level(), (BlockPos)this.be.getBlockPos()), (Player)player, (Block)((Block)ModBlocks.MACHINE_SATLINKER.get()));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            newStack = stack.copy();
            if (index < 3 ? !this.moveItemStackTo(stack, 3, this.slots.size(), true) : !this.moveItemStackTo(stack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }
}

