/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.screens;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Locale;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CalculatorScreen
extends Screen {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/gui/calculator.png");
    private int xSize = 220;
    private int ySize = 50;
    private EditBox inputBox;
    private String latestResult = "?";
    private static int factorialCurrentN;

    protected void init() {
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        this.inputBox = new EditBox(this.font, x + 5, y + 8, 210, 13, (Component)Component.literal((String)"9 + 10"));
        this.inputBox.setCanLoseFocus(false);
        this.inputBox.setFocused(true);
        this.inputBox.setMaxLength(1000);
    }

    public void onClose() {
        this.minecraft.popGuiLayer();
    }

    public CalculatorScreen() {
        super((Component)Component.empty());
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean b = this.inputBox.keyPressed(keyCode, scanCode, modifiers);
        if (keyCode == 257 || keyCode == 335) {
            String input = CalculatorScreen.regexInput(this.inputBox.getValue());
            try {
                double result = CalculatorScreen.evaluateExpression(input);
                String plainStringRepresentation = new BigDecimal(result, MathContext.DECIMAL64).toPlainString();
                Minecraft.getInstance().keyboardHandler.setClipboard(plainStringRepresentation);
                this.inputBox.setValue(plainStringRepresentation);
                this.inputBox.moveCursorToEnd(false);
                this.inputBox.setHighlightPos(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        this.update();
        return b || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.inputBox.charTyped(codePoint, modifiers)) {
            this.update();
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    private void update() {
        String input = CalculatorScreen.regexInput(this.inputBox.getValue());
        if (input.isEmpty()) {
            this.latestResult = "?";
            return;
        }
        try {
            this.latestResult = Double.toString(CalculatorScreen.evaluateExpression(input));
        }
        catch (Exception e) {
            this.latestResult = e.getClass().getName();
        }
    }

    private static String regexInput(String s) {
        return s.replaceAll("[^\\d+\\-*/^!.()\\sA-Za-z]+", "");
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        int x = (this.width - this.xSize) / 2;
        int y = (this.height - this.ySize) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.xSize, this.ySize);
        this.inputBox.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, "=" + this.latestResult, x + 5, y + 30, -1);
    }

    public static double evaluateExpression(String input) {
        if (input.contains("^")) {
            input = CalculatorScreen.preEvaluatePower(input);
        }
        char[] tokens = input.toCharArray();
        Stack<Double> values = new Stack<Double>();
        Stack<String> operators = new Stack<String>();
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i] == ' ') continue;
            if (tokens[i] >= '0' && tokens[i] <= '9' || tokens[i] == '.' || tokens[i] == '-' && (i == 0 || "+-*/^(".contains(String.valueOf(tokens[i - 1])))) {
                StringBuilder buffer = new StringBuilder();
                if (tokens[i] == '-') {
                    buffer.append('-');
                    ++i;
                }
                while (i < tokens.length && (tokens[i] >= '0' && tokens[i] <= '9' || tokens[i] == '.')) {
                    buffer.append(tokens[i++]);
                }
                values.push(Double.parseDouble(buffer.toString()));
                --i;
                continue;
            }
            if (tokens[i] == '(') {
                operators.push(Character.toString(tokens[i]));
                continue;
            }
            if (tokens[i] == ')') {
                while (!operators.isEmpty() && ((String)operators.peek()).charAt(0) != '(') {
                    values.push(CalculatorScreen.evaluateOperator(((String)operators.pop()).charAt(0), (Double)values.pop(), (Double)values.pop()));
                }
                operators.pop();
                if (operators.isEmpty() || ((String)operators.peek()).length() <= 1) continue;
                values.push(CalculatorScreen.evaluateFunction((String)operators.pop(), (Double)values.pop()));
                continue;
            }
            if (tokens[i] == '+' || tokens[i] == '-' || tokens[i] == '*' || tokens[i] == '/' || tokens[i] == '^') {
                while (!operators.isEmpty() && CalculatorScreen.hasPrecedence(String.valueOf(tokens[i]), (String)operators.peek())) {
                    values.push(CalculatorScreen.evaluateOperator(((String)operators.pop()).charAt(0), (Double)values.pop(), (Double)values.pop()));
                }
                operators.push(Character.toString(tokens[i]));
                continue;
            }
            if (tokens[i] == '!') {
                values.push(Double.valueOf(CalculatorScreen.factorial((int)Math.round((Double)values.pop()))));
                continue;
            }
            if ((tokens[i] < 'A' || tokens[i] > 'Z') && (tokens[i] < 'a' || tokens[i] > 'z')) continue;
            StringBuilder charBuffer = new StringBuilder();
            while (i < tokens.length && (tokens[i] >= 'A' && tokens[i] <= 'Z' || tokens[i] >= 'a' && tokens[i] <= 'z')) {
                charBuffer.append(tokens[i++]);
            }
            String string = charBuffer.toString();
            if (string.equalsIgnoreCase("pi")) {
                values.push(Math.PI);
            } else if (string.equalsIgnoreCase("e")) {
                values.push(Math.E);
            } else {
                operators.push(string.toLowerCase(Locale.ROOT));
            }
            --i;
        }
        while (!operators.empty()) {
            values.push(CalculatorScreen.evaluateOperator(((String)operators.pop()).charAt(0), (Double)values.pop(), (Double)values.pop()));
        }
        return (Double)values.pop();
    }

    private static double evaluateOperator(char operator, double x, double y) {
        return switch (operator) {
            case '+' -> y + x;
            case '-' -> y - x;
            case '*' -> y * x;
            case '/' -> y / x;
            case '^' -> Math.pow(y, x);
            default -> 0.0;
        };
    }

    private static double evaluateFunction(String function, double x) {
        return switch (function) {
            case "sqrt" -> Math.sqrt(x);
            case "sin" -> Math.sin(x);
            case "cos" -> Math.cos(x);
            case "tan" -> Math.tan(x);
            case "asin" -> Math.asin(x);
            case "acos" -> Math.acos(x);
            case "atan" -> Math.atan(x);
            case "log" -> Math.log10(x);
            case "ln" -> Math.log(x);
            case "ceil" -> Math.ceil(x);
            case "floor" -> Math.floor(x);
            case "round" -> Math.round(x);
            default -> 0.0;
        };
    }

    private static boolean hasPrecedence(String first, String second) {
        if (second.length() > 1) {
            return false;
        }
        char firstChar = first.charAt(0);
        char secondChar = second.charAt(0);
        if (secondChar == '(' || secondChar == ')') {
            return false;
        }
        return firstChar != '*' && firstChar != '/' && firstChar != '^' || secondChar != '+' && secondChar != '-';
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String preEvaluatePower(String input) {
        int exponentExpressionEnd;
        double result;
        int baseExpressionStart;
        do {
            int powerOperatorIndex;
            boolean previousTokenIsParentheses = ((String)input).charAt((powerOperatorIndex = ((String)input).lastIndexOf(94)) - 1) == ')';
            int parenthesesDepth = previousTokenIsParentheses ? 1 : 0;
            int n = baseExpressionStart = previousTokenIsParentheses ? powerOperatorIndex - 2 : powerOperatorIndex - 1;
            block11: while (baseExpressionStart >= 0) {
                switch (((String)input).charAt(baseExpressionStart)) {
                    case ')': {
                        if (!previousTokenIsParentheses) break block11;
                        ++parenthesesDepth;
                        break;
                    }
                    case '(': {
                        if (!previousTokenIsParentheses || parenthesesDepth <= 0) break block11;
                        --parenthesesDepth;
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case '^': {
                        if (parenthesesDepth == 0) break block11;
                    }
                }
                --baseExpressionStart;
            }
            ++baseExpressionStart;
            if (parenthesesDepth > 0) {
                throw new IllegalArgumentException("Incomplete parentheses");
            }
            boolean nextTokenIsParentheses = ((String)input).charAt(powerOperatorIndex + 1) == '(';
            parenthesesDepth = nextTokenIsParentheses ? 1 : 0;
            int n2 = exponentExpressionEnd = nextTokenIsParentheses ? powerOperatorIndex + 2 : powerOperatorIndex + 1;
            block12: while (exponentExpressionEnd < ((String)input).length()) {
                switch (((String)input).charAt(exponentExpressionEnd)) {
                    case '(': {
                        if (!nextTokenIsParentheses) break block12;
                        ++parenthesesDepth;
                        break;
                    }
                    case ')': {
                        if (!nextTokenIsParentheses || parenthesesDepth <= 0) break block12;
                        --parenthesesDepth;
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case '^': {
                        if (parenthesesDepth == 0) break block12;
                    }
                }
                ++exponentExpressionEnd;
            }
            if (parenthesesDepth > 0) {
                throw new IllegalArgumentException("Incomplete parentheses");
            }
            double base = CalculatorScreen.evaluateExpression(((String)input).substring(baseExpressionStart, powerOperatorIndex));
            double exponent = CalculatorScreen.evaluateExpression(((String)input).substring(powerOperatorIndex + 1, exponentExpressionEnd));
            result = Math.pow(base, exponent);
        } while (((String)(input = ((String)input).substring(0, baseExpressionStart) + new BigDecimal(result, MathContext.DECIMAL64).toPlainString() + ((String)input).substring(exponentExpressionEnd))).contains("^"));
        return input;
    }

    private static int factorial(int in) {
        if (in < 0) {
            throw new IllegalArgumentException("Factorial needs n >= 0");
        }
        if (in < 2) {
            return 1;
        }
        int p = 1;
        int r = 1;
        factorialCurrentN = 1;
        int h = 0;
        int shift = 0;
        int high = 1;
        int log2n = CalculatorScreen.log2(in);
        while (h != in) {
            shift += h;
            h = in >> log2n--;
            int len = high;
            high = h - 1 | 1;
            if ((len = (high - len) / 2) <= 0) continue;
            r *= (p *= CalculatorScreen.factorialProduct(len));
        }
        return r << shift;
    }

    private static int factorialProduct(int in) {
        int m = in / 2;
        if (m == 0) {
            return factorialCurrentN += 2;
        }
        if (in == 2) {
            factorialCurrentN = factorialCurrentN + 2;
            return factorialCurrentN * (factorialCurrentN += 2);
        }
        return CalculatorScreen.factorialProduct(in - m) * CalculatorScreen.factorialProduct(m);
    }

    private static int log2(int in) {
        int log = 0;
        if ((in & 0xFFFF0000) != 0) {
            in >>>= 16;
            log = 16;
        }
        if (in >= 256) {
            in >>>= 8;
            log += 8;
        }
        if (in >= 16) {
            in >>>= 4;
            log += 4;
        }
        if (in >= 4) {
            in >>>= 2;
            log += 2;
        }
        return log + (in >>> 1);
    }
}

