/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.screens;

import com.hbm.handler.HTTPHandler;
import com.hbm.util.i18n.I18nUtil;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class LoadingScreenRendererNT {
    private final Minecraft mc;
    private final Random random = new Random();
    private String tipOfTheDay = "Tip of the day: " + this.chooseTip();

    public LoadingScreenRendererNT(Minecraft mc) {
        this.mc = mc;
    }

    private String chooseTip() {
        if (HTTPHandler.tipOfTheDay.isEmpty()) {
            return "Explore! There's tons of free stuff to find.";
        }
        return HTTPHandler.tipOfTheDay.get(this.random.nextInt(HTTPHandler.tipOfTheDay.size()));
    }

    public void resetMessage() {
        this.tipOfTheDay = "Tip of the day: " + this.chooseTip();
    }

    public void render(GuiGraphics guiGraphics) {
        int width = this.mc.getWindow().getGuiScaledWidth();
        int height = this.mc.getWindow().getGuiScaledHeight();
        String[] frags = I18nUtil.resolveKeyArray(this.tipOfTheDay, new Object[0]);
        int y = height / 2 / 3;
        for (int i = 0; i < frags.length; ++i) {
            String frag = frags[i];
            Font font = this.mc.font;
            MutableComponent mutableComponent = Component.literal((String)frag).withStyle(ChatFormatting.YELLOW);
            int n = width / 2;
            Objects.requireNonNull(this.mc.font);
            guiGraphics.drawCenteredString(font, (Component)mutableComponent, n, y + i * 9, 0xFFFFFF);
        }
    }
}

