/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.screens;

import com.hbm.HBMsNTM;
import com.hbm.items.ISatChip;
import com.hbm.items.tools.SatelliteInterfaceItem;
import com.hbm.network.toserver.SatelliteLaser;
import com.hbm.saveddata.satellite.Satellite;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;

public class SatelliteInterfaceScreen
extends Screen {
    protected static final ResourceLocation TEXTURE = HBMsNTM.withDefaultNamespaceNT("textures/gui/satellites/gui_sat_interface.png");
    protected int xSize = 216;
    protected int ySize = 216;
    protected int guiLeft;
    protected int guiTop;
    private Player player;
    private int x;
    private int z;
    private NativeImage mapImage;
    private DynamicTexture mapTexture;
    private ResourceLocation mapTextureLocation;
    private int scanPos = 0;
    private long lastMilli = 0L;

    protected void init() {
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.x = (int)this.player.getX();
        this.z = (int)this.player.getZ();
        this.mapImage = new NativeImage(200, 200, false);
        this.mapTexture = new DynamicTexture(this.mapImage);
        this.mapTextureLocation = this.minecraft.getTextureManager().register("sat_map_" + String.valueOf(UUID.randomUUID()), this.mapTexture);
        this.scanPos = 0;
        this.mapImage.fillRect(0, 0, 200, 200, 0);
        this.mapTexture.upload();
    }

    public void onClose() {
        super.onClose();
        if (this.mapTexture != null) {
            this.mapTexture.close();
        }
        if (this.mapImage != null) {
            this.mapImage.close();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (SatelliteInterfaceItem.currentSat != null && SatelliteInterfaceItem.currentSat.ifaceAcs.contains((Object)Satellite.InterfaceActions.CAN_CLICK) && mouseX >= (double)(this.guiLeft + 8) && mouseX < (double)(this.guiLeft + 208) && mouseY >= (double)(this.guiTop + 8) && mouseY < (double)(this.guiTop + 208) && this.player != null) {
            int x = (int)((double)(this.x - this.guiLeft) + mouseX - 8.0 - 100.0);
            int z = (int)((double)(this.z - this.guiTop) + mouseY - 8.0 - 100.0);
            PacketDistributor.sendToServer((CustomPacketPayload)new SatelliteLaser(x, z, ISatChip.getFreqS(this.player.getMainHandItem())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public SatelliteInterfaceScreen(Player player) {
        super((Component)Component.empty());
        this.player = player;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderTransparentBackground(guiGraphics);
        this.renderBg(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderCoords(guiGraphics, mouseX, mouseY);
        this.renderOther(guiGraphics);
    }

    protected void renderCoords(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (SatelliteInterfaceItem.currentSat != null && SatelliteInterfaceItem.currentSat.ifaceAcs.contains((Object)Satellite.InterfaceActions.SHOW_COORDS) && mouseX >= this.guiLeft + 8 && mouseX < this.guiLeft + 208 && mouseY >= this.guiTop + 8 && mouseY < this.guiTop + 208 && this.player != null) {
            int x = this.x - this.guiLeft + mouseX - 8 - 100;
            int z = this.z - this.guiTop + mouseY - 8 - 100;
            guiGraphics.renderComponentTooltip(this.minecraft.font, List.of(Component.literal((String)(x + " / " + z))), mouseX, mouseY);
        }
    }

    protected void renderOther(GuiGraphics guiGraphics) {
        guiGraphics.blit(TEXTURE, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (SatelliteInterfaceItem.currentSat == null) {
            this.renderNotConnected(guiGraphics);
        } else {
            if (SatelliteInterfaceItem.currentSat.satIface != Satellite.Interfaces.SAT_PANEL) {
                this.renderNoService(guiGraphics);
                return;
            }
            if (SatelliteInterfaceItem.currentSat.ifaceAcs.contains((Object)Satellite.InterfaceActions.HAS_MAP)) {
                this.drawMap(guiGraphics);
            }
            if (SatelliteInterfaceItem.currentSat.ifaceAcs.contains((Object)Satellite.InterfaceActions.HAS_RADAR)) {
                this.renderRadar(guiGraphics);
            }
        }
    }

    private void progresScan() {
        if (this.lastMilli + 25L < System.currentTimeMillis()) {
            this.lastMilli = System.currentTimeMillis();
            ++this.scanPos;
        }
        if (this.scanPos >= 200) {
            this.scanPos -= 200;
        }
    }

    private void drawMap(GuiGraphics guiGraphics) {
        Level level = this.player.level();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int i = -100; i < 100; ++i) {
            int worldX = this.x + i;
            int worldZ = this.z + this.scanPos - 100;
            int worldY = level.getHeight(Heightmap.Types.WORLD_SURFACE, worldX, worldZ) - 1;
            pos.set(worldX, worldY, worldZ);
            int rgb = level.getBlockState((BlockPos)pos).getMapColor((BlockGetter)level, (BlockPos)pos).calculateRGBColor(MapColor.Brightness.NORMAL);
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            this.mapImage.setPixelRGBA(i + 100, this.scanPos, FastColor.ARGB32.color((int)255, (int)r, (int)g, (int)b));
        }
        this.mapTexture.upload();
        guiGraphics.blit(this.mapTextureLocation, this.guiLeft + 8, this.guiTop + 8, 0.0f, 0.0f, 200, 200, 200, 200);
        this.progresScan();
    }

    private void renderRadar(GuiGraphics guiGraphics) {
        List entities = this.player.level().getEntities((Entity)this.player, new AABB(this.player.getX() - 100.0, 0.0, this.player.getZ() - 100.0, this.player.getX() + 100.0, 5000.0, this.player.getZ() + 100.0));
        if (!entities.isEmpty()) {
            for (Entity entity : entities) {
                if (!((double)(entity.getBbWidth() * entity.getBbWidth() * entity.getBbHeight()) >= 0.5)) continue;
                int x = (int)((entity.getX() - (double)this.x) / 201.0 * 192.0) - 4;
                int z = (int)((entity.getZ() - (double)this.z) / 201.0 * 192.0) - 4 - 9;
                int t = 5;
                if (entity instanceof Mob) {
                    t = 6;
                }
                if (entity instanceof Player) {
                    t = 7;
                }
                guiGraphics.blit(TEXTURE, this.guiLeft + 108 + x, this.guiTop + 117 + z, 216, 8 * t, 8, 8);
            }
        }
    }

    private void renderNoService(GuiGraphics guiGraphics) {
        guiGraphics.blit(TEXTURE, (this.width - 77) / 2, (this.height - 12) / 2, 0, 228, 77, 12);
    }

    private void renderNotConnected(GuiGraphics guiGraphics) {
        guiGraphics.blit(TEXTURE, (this.width - 121) / 2, (this.height - 12) / 2, 0, 216, 121, 12);
    }
}

