/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.screens;

import com.hbm.HBMsNTMClient;
import com.hbm.handler.ability.AvailableAbilities;
import com.hbm.handler.ability.IBaseAbility;
import com.hbm.handler.ability.IToolAreaAbility;
import com.hbm.handler.ability.IToolHarvestAbility;
import com.hbm.handler.ability.ToolPreset;
import com.hbm.items.tools.ToolAbilityItem;
import com.hbm.lib.ModSounds;
import com.hbm.network.toserver.CompoundTagItemControl;
import com.hbm.util.TagsUtilDegradation;
import com.hbm.util.Tuple;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ToolAbilityScreen
extends Screen {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/gui/tool/gui_tool_ability.png");
    protected int guiLeft;
    protected int guiTop;
    protected int xSize;
    protected int ySize;
    protected int insetWidth;
    public static final List<AbilityInfo> abilitiesArea = new ArrayList<AbilityInfo>();
    public static final List<AbilityInfo> abilitiesHarvest = new ArrayList<AbilityInfo>();
    protected ItemStack toolStack;
    protected AvailableAbilities availableAbilities;
    protected ToolAbilityItem.Configuration config;
    protected int hoverIdxHarvest = -1;
    protected int hoverIdxArea = -1;
    protected int hoverIdxExtraBtn = -1;

    public ToolAbilityScreen(AvailableAbilities availableAbilities) {
        super((Component)Component.empty());
        this.availableAbilities = availableAbilities;
        this.xSize = 186;
        this.ySize = 76;
        this.insetWidth = 20 * Math.max(abilitiesArea.size() - 4, abilitiesHarvest.size() - 8);
        this.xSize += this.insetWidth;
    }

    protected void init() {
        this.toolStack = Minecraft.getInstance().player.getMainHandItem();
        if (this.toolStack.isEmpty()) {
            this.onClose();
        }
        this.config = ((ToolAbilityItem)this.toolStack.getItem()).getConfiguration(this.toolStack);
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fillGradient(0, 0, this.width, this.height, -1072689136, -804253680);
        this.blitStretched(guiGraphics, this.guiLeft, this.guiTop, 0, 0, this.xSize, this.xSize - this.insetWidth, this.ySize, 74, 87);
        ToolPreset activePreset = this.config.getActivePreset();
        this.hoverIdxArea = this.blitSwitches(guiGraphics, abilitiesArea, activePreset.areaAbility, activePreset.areaAbilityLevel, this.guiLeft + 15, this.guiTop + 25, mouseX, mouseY);
        this.hoverIdxHarvest = this.blitSwitches(guiGraphics, abilitiesHarvest, activePreset.harvestAbility, activePreset.harvestAbilityLevel, this.guiLeft + 15, this.guiTop + 45, mouseX, mouseY);
        this.drawNumber(guiGraphics, this.config.currentPreset + 1, this.guiLeft + this.insetWidth + 115, this.guiTop + 25);
        this.drawNumber(guiGraphics, this.config.presets.size(), this.guiLeft + this.insetWidth + 149, this.guiTop + 25);
        int extraX = this.guiLeft + this.xSize - 86;
        this.hoverIdxExtraBtn = -1;
        for (int i = 0; i < 7; ++i) {
            if (!this.isInAABB(mouseX, mouseY, extraX + i * 11, this.guiTop + 11, 9, 9)) continue;
            this.hoverIdxExtraBtn = i;
            guiGraphics.blit(TEXTURE, extraX + i * 11, this.guiTop + 11, 193 + i * 9, 0, 9, 9);
        }
        String tooltipValue = "";
        if (this.hoverIdxArea != -1) {
            level = 0;
            if (ToolAbilityScreen.abilitiesArea.get((int)this.hoverIdxArea).ability == activePreset.areaAbility) {
                level = activePreset.areaAbilityLevel;
            }
            tooltipValue = ToolAbilityScreen.abilitiesArea.get((int)this.hoverIdxArea).ability.getFullName(level);
        } else if (this.hoverIdxHarvest != -1) {
            level = 0;
            if (ToolAbilityScreen.abilitiesHarvest.get((int)this.hoverIdxHarvest).ability == activePreset.harvestAbility) {
                level = activePreset.harvestAbilityLevel;
            }
            tooltipValue = ToolAbilityScreen.abilitiesHarvest.get((int)this.hoverIdxHarvest).ability.getFullName(level);
        } else if (this.hoverIdxExtraBtn != -1) {
            switch (this.hoverIdxExtraBtn) {
                case 0: {
                    String string = "Reset all presets";
                    break;
                }
                case 1: {
                    String string = "Delete current preset";
                    break;
                }
                case 2: {
                    String string = "Add new preset";
                    break;
                }
                case 3: {
                    String string = "Select first preset";
                    break;
                }
                case 4: {
                    String string = "Next preset";
                    break;
                }
                case 5: {
                    String string = "Previous preset";
                    break;
                }
                case 6: {
                    String string = "Close window";
                    break;
                }
                default: {
                    String string = tooltipValue = tooltipValue;
                }
            }
        }
        if (!tooltipValue.isEmpty()) {
            int tooltipWidth = Math.max(6, this.font.width(tooltipValue));
            int tooltipX = this.guiLeft + this.xSize / 2 - tooltipWidth / 2;
            int tooltipY = this.guiTop + this.ySize + 1 + 4;
            this.blitStretched(guiGraphics, tooltipX - 5, tooltipY - 4, 0, 76, tooltipWidth + 10, 186, 15, 3, 3);
            guiGraphics.drawString(this.font, tooltipValue, tooltipX, tooltipY, -1);
        }
    }

    private void blitStretched(GuiGraphics guiGraphics, int x, int y, int u, int v, int realWidth, int width, int height, int keepLeft, int keepRight) {
        int midWidth = width - keepLeft - keepRight;
        int realMidWidth = realWidth - keepLeft - keepRight;
        guiGraphics.blit(TEXTURE, x, y, u, v, keepLeft, height);
        for (int i = 0; i < realMidWidth; i += midWidth) {
            guiGraphics.blit(TEXTURE, x + keepLeft + i, y, u + keepLeft, v, Math.min(midWidth, realMidWidth - i), height);
        }
        guiGraphics.blit(TEXTURE, x + keepLeft + realMidWidth, y, u + keepLeft + midWidth, v, keepRight, height);
    }

    private int blitSwitches(GuiGraphics guiGraphics, List<AbilityInfo> abilities, IBaseAbility selectedAbility, int selectedLevel, int x, int y, int mouseX, int mouseY) {
        int hoverIdx = -1;
        for (int i = 0; i < abilities.size(); ++i) {
            boolean isHovered;
            AbilityInfo abilityInfo = abilities.get(i);
            boolean available = this.abilityAvailable(abilityInfo.ability);
            boolean selected = abilityInfo.ability == selectedAbility;
            guiGraphics.blit(TEXTURE, x + 20 * i, y, abilityInfo.textureU + (available ? 16 : 0), abilityInfo.textureV, 16, 16);
            if (abilityInfo.ability.levels() > 1) {
                int level = 0;
                if (selected) {
                    level = selectedLevel + 1;
                }
                int maxLevel = 5;
                if (level > 10 || level < 0) {
                    level = -1;
                }
                guiGraphics.blit(TEXTURE, x + 20 * i + 17, y + 1, 188 + level * 2, maxLevel * 14, 2, 14);
            }
            if (isHovered = this.isInAABB(mouseX, mouseY, x + 20 * i, y, 16, 16)) {
                hoverIdx = i;
            }
            if (selected) {
                guiGraphics.blit(TEXTURE, x + 20 * i - 1, y - 1, 220, 9, 18, 18);
                continue;
            }
            if (!available || !isHovered) continue;
            guiGraphics.blit(TEXTURE, x + 20 * i - 1, y - 1, 238, 9, 18, 18);
        }
        return hoverIdx;
    }

    private void drawNumber(GuiGraphics g, int n, int x, int y) {
        this.drawDigit(g, (n += 100) / 10 % 10, x, y);
        this.drawDigit(g, n % 10, x + 12, y);
    }

    private void drawDigit(GuiGraphics g, int d, int x, int y) {
        g.blit(TEXTURE, x, y, d * 10, 123, 10, 15);
    }

    private boolean isInAABB(int mouseX, int mouseY, int x, int y, int width, int height) {
        return x <= mouseX && x + width > mouseX && y <= mouseY && y + height > mouseY;
    }

    private boolean abilityAvailable(IBaseAbility ability) {
        if (!this.availableAbilities.supportsAbility(ability)) {
            return false;
        }
        ToolPreset activePreset = this.config.getActivePreset();
        return !(ability instanceof IToolHarvestAbility) || ability == IToolHarvestAbility.NONE || activePreset.areaAbility.allowsHarvest(activePreset.areaAbilityLevel);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (scrollY < 0.0) {
            this.doPrevPreset(true);
        }
        if (scrollY > 0.0) {
            this.doNextPreset(true);
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double x, double y, int button) {
        ToolPreset activePreset = this.config.getActivePreset();
        int mouseX = (int)x;
        int mouseY = (int)y;
        Tuple.Pair<IBaseAbility, Integer> clickResult = this.handleSwitchesClicked(abilitiesArea, activePreset.areaAbility, activePreset.areaAbilityLevel, this.hoverIdxArea, mouseX, mouseY);
        activePreset.areaAbility = (IToolAreaAbility)clickResult.key;
        activePreset.areaAbilityLevel = (Integer)clickResult.value;
        clickResult = this.handleSwitchesClicked(abilitiesHarvest, activePreset.harvestAbility, activePreset.harvestAbilityLevel, this.hoverIdxHarvest, mouseX, mouseY);
        activePreset.harvestAbility = (IToolHarvestAbility)clickResult.key;
        activePreset.harvestAbilityLevel = (Integer)clickResult.value;
        if (!activePreset.areaAbility.allowsHarvest(activePreset.areaAbilityLevel)) {
            activePreset.harvestAbility = IToolHarvestAbility.NONE;
            activePreset.harvestAbilityLevel = 0;
        }
        if (this.hoverIdxExtraBtn != -1) {
            switch (this.hoverIdxExtraBtn) {
                case 0: {
                    this.doResetPresets();
                    break;
                }
                case 1: {
                    this.doDelPreset();
                    break;
                }
                case 2: {
                    this.doAddPreset();
                    break;
                }
                case 3: {
                    this.doZeroPreset();
                    break;
                }
                case 4: {
                    this.doNextPreset(false);
                    break;
                }
                case 5: {
                    this.doPrevPreset(false);
                    break;
                }
                case 6: {
                    this.onClose();
                }
            }
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)0.5f));
        }
        if (!this.isInAABB(mouseX, mouseY, this.guiLeft, this.guiTop, this.xSize, this.ySize)) {
            this.onClose();
        }
        return super.mouseClicked(x, y, button);
    }

    private Tuple.Pair<IBaseAbility, Integer> handleSwitchesClicked(List<AbilityInfo> abilities, IBaseAbility selectedAbility, int selectedLevel, int hoverIdx, int mouseX, int mouseY) {
        IBaseAbility hoveredAbility;
        boolean available;
        if (hoverIdx != -1 && (available = this.abilityAvailable(hoveredAbility = abilities.get((int)hoverIdx).ability))) {
            int availableLevels = this.availableAbilities.maxLevel(hoveredAbility) + 1;
            if (hoveredAbility != selectedAbility || availableLevels > 1) {
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)ModSounds.TECH_BOOP.get()), (float)2.0f));
            }
            selectedLevel = hoveredAbility == selectedAbility ? (selectedLevel + 1) % availableLevels : 0;
            selectedAbility = hoveredAbility;
        }
        return new Tuple.Pair<IBaseAbility, Integer>(selectedAbility, selectedLevel);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (keyCode == 256 && this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void doResetPresets() {
        this.config.reset(this.availableAbilities);
    }

    protected void doDelPreset() {
        if (this.config.presets.size() <= 1) {
            return;
        }
        this.config.presets.remove(this.config.currentPreset);
        this.config.currentPreset = Math.min(this.config.currentPreset, this.config.presets.size() - 1);
    }

    protected void doAddPreset() {
        if (this.config.presets.size() >= 99) {
            return;
        }
        this.config.presets.add(this.config.currentPreset + 1, new ToolPreset());
        ++this.config.currentPreset;
    }

    protected void doZeroPreset() {
        this.config.currentPreset = 0;
    }

    protected void doNextPreset(boolean bound) {
        if (bound) {
            if (this.config.currentPreset < this.config.presets.size() - 1) {
                ++this.config.currentPreset;
            }
        } else {
            this.config.currentPreset = (this.config.currentPreset + 1) % this.config.presets.size();
        }
    }

    protected void doPrevPreset(boolean bound) {
        if (bound) {
            if (this.config.currentPreset > 0) {
                --this.config.currentPreset;
            }
        } else {
            this.config.currentPreset = (this.config.currentPreset + this.config.presets.size() - 1) % this.config.presets.size();
        }
    }

    public void onClose() {
        super.onClose();
        LocalPlayer player = this.minecraft.player;
        ((ToolAbilityItem)this.toolStack.getItem()).setConfiguration(this.toolStack, this.config);
        PacketDistributor.sendToServer((CustomPacketPayload)new CompoundTagItemControl(TagsUtilDegradation.getTag(this.toolStack)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        HBMsNTMClient.displayTooltip(this.config.getActivePreset().getMessage(), 1000, 11);
        this.minecraft.level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.25f, this.config.getActivePreset().isNone() ? 0.75f : 1.25f);
    }

    static {
        abilitiesArea.add(new AbilityInfo(IToolAreaAbility.NONE, 0, 91));
        abilitiesArea.add(new AbilityInfo(IToolAreaAbility.RECURSION, 32, 91));
        abilitiesArea.add(new AbilityInfo(IToolAreaAbility.HAMMER, 64, 91));
        abilitiesArea.add(new AbilityInfo(IToolAreaAbility.HAMMER_FLAT, 96, 91));
        abilitiesArea.add(new AbilityInfo(IToolAreaAbility.EXPLOSION, 128, 91));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.NONE, 0, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.SILK, 32, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.LUCK, 64, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.SMELTER, 96, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.SHREDDER, 128, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.CENTRIFUGE, 160, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.CRYSTALLIZER, 192, 107));
        abilitiesHarvest.add(new AbilityInfo(IToolHarvestAbility.MERCURY, 224, 107));
    }

    public static class AbilityInfo {
        public final IBaseAbility ability;
        public int textureU;
        public int textureV;

        public AbilityInfo(IBaseAbility ability, int textureU, int textureV) {
            this.ability = ability;
            this.textureU = textureU;
            this.textureV = textureV;
        }
    }
}

