/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class ItemArmorMod
extends Item {
    public final int type;
    public final boolean helmet;
    public final boolean chestplate;
    public final boolean leggings;
    public final boolean boots;

    public ItemArmorMod(Item.Properties properties, int type, boolean helmet, boolean chestplate, boolean leggings, boolean boots) {
        super(properties.stacksTo(1));
        this.type = type;
        this.helmet = helmet;
        this.chestplate = chestplate;
        this.leggings = leggings;
        this.boots = boots;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)Component.translatable((String)"armorMod.applicableTo").withStyle(ChatFormatting.DARK_PURPLE));
        if (this.helmet && this.chestplate && this.leggings && this.boots) {
            components.add((Component)Component.translatable((String)"armorMod.all").withStyle(ChatFormatting.GRAY));
        } else {
            if (this.helmet) {
                components.add((Component)Component.translatable((String)"armorMod.helmets").withStyle(ChatFormatting.GRAY));
            }
            if (this.chestplate) {
                components.add((Component)Component.translatable((String)"armorMod.chestplates").withStyle(ChatFormatting.GRAY));
            }
            if (this.leggings) {
                components.add((Component)Component.translatable((String)"armorMod.leggings").withStyle(ChatFormatting.GRAY));
            }
            if (this.boots) {
                components.add((Component)Component.translatable((String)"armorMod.boots").withStyle(ChatFormatting.GRAY));
            }
        }
        components.add((Component)Component.translatable((String)"armorMod.slot").withStyle(ChatFormatting.DARK_PURPLE));
        switch (this.type) {
            case 0: {
                components.add((Component)Component.translatable((String)"armorMod.type.helmet").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 1: {
                components.add((Component)Component.translatable((String)"armorMod.type.chestplate").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 2: {
                components.add((Component)Component.translatable((String)"armorMod.type.leggings").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 3: {
                components.add((Component)Component.translatable((String)"armorMod.type.boots").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 4: {
                components.add((Component)Component.translatable((String)"armorMod.type.servo").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 5: {
                components.add((Component)Component.translatable((String)"armorMod.type.cladding").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 6: {
                components.add((Component)Component.translatable((String)"armorMod.type.insert").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 7: {
                components.add((Component)Component.translatable((String)"armorMod.type.special").withStyle(ChatFormatting.GRAY));
                break;
            }
            case 8: {
                components.add((Component)Component.translatable((String)"armorMod.type.battery").withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public void addDesc(List<Component> list, ItemStack stack, ItemStack armor) {
        list.add(stack.getDisplayName());
    }

    public void modUpdate(LivingEntity entity, ItemStack armor) {
    }

    public void modDamage(LivingDamageEvent.Pre event, ItemStack armor) {
    }

    @Nullable
    public <K, V> Multimap<K, V> getModifiers(ItemStack armor) {
        return null;
    }
}

