/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.food;

import com.hbm.blocks.ITooltipProvider;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.items.ModItems;
import com.hbm.util.ContaminationUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemEnergy
extends PotionItem {
    private Item container = null;
    private Item cap = null;
    private boolean requiresOpener = false;

    public ItemStack getDefaultInstance() {
        return new ItemStack((ItemLike)this);
    }

    public String getDescriptionId(ItemStack stack) {
        return this.getDescriptionId();
    }

    public ItemEnergy(Item.Properties properties) {
        super(properties);
    }

    public ItemEnergy makeBottle(Item bottle, Item cap) {
        this.container = bottle;
        this.cap = cap;
        this.requiresOpener = true;
        return this;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity drinker) {
        Player player;
        Player player2 = player = drinker instanceof Player ? (Player)drinker : null;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
        }
        if (!level.isClientSide) {
            if (this == ModItems.CHOCOLATE_MILK.get() && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ExplosionLarge.explode(serverLevel, drinker.getX(), drinker.getY(), drinker.getZ(), 50, true, false, false, (Entity)drinker);
            }
            if (this == ModItems.BOTTLE_NUKA.get()) {
                drinker.heal(4.0f);
                drinker.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1));
                drinker.addEffect(new MobEffectInstance(MobEffects.JUMP, 600, 1));
                ContaminationUtil.contaminate(drinker, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, 5.0f);
            }
            if (this == ModItems.BOTTLE_CHERRY.get()) {
                drinker.heal(6.0f);
                drinker.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 0));
                drinker.addEffect(new MobEffectInstance(MobEffects.JUMP, 600, 2));
                ContaminationUtil.contaminate(drinker, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, 5.0f);
            }
            if (this == ModItems.BOTTLE_QUANTUM.get()) {
                drinker.heal(10.0f);
                drinker.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1));
                drinker.addEffect(new MobEffectInstance(MobEffects.JUMP, 600, 2));
                drinker.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 600, 1));
                ContaminationUtil.contaminate(drinker, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, 15.0f);
            }
            if (this == ModItems.BOTTLE_SPARKLE.get()) {
                drinker.heal(10.0f);
                drinker.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 600, 1));
                drinker.addEffect(new MobEffectInstance(MobEffects.JUMP, 600, 2));
                drinker.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 600, 1));
                drinker.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 600, 1));
                ContaminationUtil.contaminate(drinker, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.RAD_BYPASS, 5.0f);
            }
        }
        if (player != null) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            stack.consume(1, (LivingEntity)player);
        }
        if (player != null && !player.hasInfiniteMaterials()) {
            if (this.cap != null) {
                player.getInventory().add(new ItemStack((ItemLike)this.cap));
            }
            if (this.container != null) {
                player.getInventory().add(new ItemStack((ItemLike)this.container));
            }
        }
        drinker.gameEvent((Holder)GameEvent.DRINK);
        return stack;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!this.requiresOpener) {
            return super.use(level, player, hand);
        }
        for (ItemStack stack : player.getInventory().items) {
            if (!stack.is(ModItems.BOTTLE_OPENER)) continue;
            return super.use(level, player, hand);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        for (String s : ITooltipProvider.getDescriptionWithP11(this.getDescriptionId())) {
            tooltipComponents.add((Component)Component.translatable((String)s).withStyle(ChatFormatting.GRAY));
        }
    }
}

