/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.HBMsNTM;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.config.MainConfig;
import com.hbm.explosion.vanillant.ExplosionVNT;
import com.hbm.interfaces.IBomb;
import com.hbm.items.ModItems;
import com.hbm.lib.ModSounds;
import com.hbm.util.TagsUtilDegradation;
import com.hbm.util.i18n.I18nUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DangerousDropItem
extends Item {
    public DangerousDropItem(Item.Properties properties) {
        super(properties);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity itemEntity) {
        Level level = itemEntity.level();
        if (level.isClientSide) {
            return false;
        }
        int lifespan = stack.getEntityLifespan(level);
        if (itemEntity.getAge() >= lifespan - 1) {
            return false;
        }
        String throwerName = "Unknown";
        if (TagsUtilDegradation.getTag(stack).contains("lastUser")) {
            throwerName = TagsUtilDegradation.getTag(stack).getString("lastUser");
        }
        if (itemEntity.getAge() > 5) {
            if (stack.is((Item)ModItems.DETONATOR_DEADMAN.get())) {
                int z;
                int y;
                CompoundTag tag;
                int x;
                BlockPos pos;
                Block block;
                if (TagsUtilDegradation.containsAnyTag(stack) && (block = level.getBlockState(pos = new BlockPos(x = (tag = TagsUtilDegradation.getTag(stack)).getInt("x"), y = tag.getInt("y"), z = tag.getInt("z"))).getBlock()) instanceof IBomb) {
                    IBomb bomb = (IBomb)block;
                    bomb.explode(level, pos);
                    if (((Boolean)MainConfig.COMMON.ENABLE_EXTENDED_LOGGING.get()).booleanValue()) {
                        HBMsNTM.LOGGER.info("[DEAD MAN'S DETONATOR] {} detonated {} at {} / {} / {}!", new Object[]{throwerName, block.getName().getString(), x, y, z});
                    }
                }
                level.explode(null, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), 0.0f, Level.ExplosionInteraction.NONE);
                itemEntity.discard();
                return true;
            }
            if (stack.is((Item)ModItems.DETONATOR_DE.get()) && ((Boolean)MainConfig.COMMON.DROP_DEAD_MANS_EXPLOSIVE.get()).booleanValue()) {
                level.explode(null, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), 15.0f, Level.ExplosionInteraction.TNT);
                itemEntity.discard();
                return true;
            }
        }
        if (itemEntity.onGround() && stack.is((Item)ModItems.CELL_ANTIMATTER.get()) && ((Boolean)MainConfig.COMMON.DROP_CELL.get()).booleanValue()) {
            new ExplosionVNT(level, itemEntity.getX(), itemEntity.getY(), itemEntity.getZ(), 5.0f).makeAmat().explode();
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        for (String s : ITooltipProvider.getDescription(stack)) {
            components.add((Component)Component.translatable((String)s).withStyle(ChatFormatting.GRAY));
        }
        if (this == ModItems.DETONATOR_DEADMAN.get()) {
            if (!TagsUtilDegradation.containsAnyTag(stack)) {
                components.add((Component)Component.translatable((String)"detonator.no_pos"));
            } else {
                CompoundTag tag = TagsUtilDegradation.getTag(stack);
                int x = tag.getInt("x");
                int y = tag.getInt("y");
                int z = tag.getInt("z");
                components.add((Component)Component.translatable((String)"detonator.set_to", (Object[])new Object[]{x, y, z}));
            }
        }
        components.add((Component)Component.literal((String)("[" + I18nUtil.resolveKey("trait.drop", new Object[0]) + "]")).withStyle(ChatFormatting.RED));
    }

    public InteractionResult useOn(UseOnContext context) {
        if (this != ModItems.DETONATOR_DEADMAN.get()) {
            return super.useOn(context);
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        if (!level.isClientSide && player.isCrouching()) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", context.getClickedPos().getX());
            tag.putInt("y", context.getClickedPos().getY());
            tag.putInt("z", context.getClickedPos().getZ());
            tag.putString("lastUser", player.getName().getString());
            TagsUtilDegradation.putTag(stack, tag);
            level.playSound(null, player.blockPosition(), (SoundEvent)ModSounds.TECH_BOOP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }
}

