/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.entity.ModEntities;
import com.hbm.entity.mob.Duck;
import com.hbm.items.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EntitySpawnerItem
extends Item {
    public EntitySpawnerItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Entity entity;
        Level level = ctx.getLevel();
        Player player = ctx.getPlayer();
        BlockPos pos = ctx.getClickedPos().relative(ctx.getClickedFace());
        if (!level.isClientSide && (entity = this.spawnCreature(level, ctx.getItemInHand(), (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5)) != null) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                Component name = ctx.getItemInHand().getHoverName();
                living.setCustomName(name);
            }
            if (player != null && !player.getAbilities().instabuild) {
                ctx.getItemInHand().shrink(1);
            }
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult hit;
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && (hit = EntitySpawnerItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY)).getType() == HitResult.Type.BLOCK) {
            BlockPos pos = hit.getBlockPos();
            if (level.getFluidState(pos).isEmpty()) {
                return InteractionResultHolder.pass((Object)stack);
            }
            Entity entity = this.spawnCreature(level, stack, (double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
            if (entity != null) {
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    Component name = stack.getHoverName();
                    living.setCustomName(name);
                }
                if (player != null && !player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    private Entity spawnCreature(Level level, ItemStack stack, double x, double y, double z) {
        Duck duck;
        Entity entity = null;
        if (stack.is((Item)ModItems.DUCK_SPAWN_EGG.get()) && (duck = (Duck)((EntityType)ModEntities.DUCK.get()).create(level)) != null) {
            duck.moveTo(x, y, z, level.random.nextFloat() * 360.0f, 0.0f);
            level.addFreshEntity((Entity)duck);
        }
        if (entity != null && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            entity.moveTo(x, y, z, Mth.wrapDegrees((float)(level.random.nextFloat() * 360.0f)), 0.0f);
            living.setYHeadRot(living.getYRot());
            living.setYBodyRot(living.getYRot());
            level.addFreshEntity(entity);
        }
        return entity;
    }
}

