/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tools;

import com.hbm.HBMsNTM;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.config.MainConfig;
import com.hbm.interfaces.IBomb;
import com.hbm.lib.ModSounds;
import com.hbm.util.TagsUtilDegradation;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DetonatorItem
extends Item {
    public DetonatorItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        if (!level.isClientSide && player.isCrouching()) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", context.getClickedPos().getX());
            tag.putInt("y", context.getClickedPos().getY());
            tag.putInt("z", context.getClickedPos().getZ());
            TagsUtilDegradation.putTag(stack, tag);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSounds.TECH_BOOP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            player.displayClientMessage((Component)Component.literal((String)("[" + this.getName(stack).getString() + "] ")).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.translatable((String)"detonator.pos_set").withStyle(ChatFormatting.GREEN)), false);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide) {
            if (!TagsUtilDegradation.containsAnyTag(stack)) {
                player.displayClientMessage((Component)Component.literal((String)("[" + this.getName(stack).getString() + "] ")).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.translatable((String)"detonator.no_pos").withStyle(ChatFormatting.RED)), false);
            } else {
                int z;
                int y;
                CompoundTag tag = TagsUtilDegradation.getTag(stack);
                int x = tag.getInt("x");
                BlockPos pos = new BlockPos(x, y = tag.getInt("y"), z = tag.getInt("z"));
                Block block = level.getBlockState(pos).getBlock();
                if (block instanceof IBomb) {
                    IBomb bomb = (IBomb)block;
                    level.playSound(null, player.blockPosition(), (SoundEvent)ModSounds.TECH_BLEEP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    IBomb.BombReturnCode ret = bomb.explode(level, pos);
                    if (((Boolean)MainConfig.COMMON.ENABLE_EXTENDED_LOGGING.get()).booleanValue()) {
                        HBMsNTM.LOGGER.info("[DETONATOR] {} detonated {} at {} / {} / {}!", new Object[]{player.getName().getString(), block.getName().getString(), x, y, z});
                    }
                    player.displayClientMessage((Component)Component.literal((String)("[" + this.getName(stack).getString() + "] ")).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.translatable((String)ret.getUnlocalizedMessage()).withStyle(ret.wasSuccessful() ? ChatFormatting.YELLOW : ChatFormatting.RED)), false);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)("[" + this.getName(stack).getString() + "] ")).withStyle(ChatFormatting.DARK_AQUA).append((Component)Component.translatable((String)IBomb.BombReturnCode.ERROR_NO_BOMB.getUnlocalizedMessage()).withStyle(ChatFormatting.RED)), false);
                }
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        for (String s : ITooltipProvider.getDescription(stack)) {
            components.add((Component)Component.translatable((String)s).withStyle(ChatFormatting.GRAY));
        }
        if (TagsUtilDegradation.containsAnyTag(stack)) {
            CompoundTag tag = TagsUtilDegradation.getTag(stack);
            int x = tag.getInt("x");
            int y = tag.getInt("y");
            int z = tag.getInt("z");
            components.add((Component)Component.translatable((String)"detonator.set_to", (Object[])new Object[]{x, y, z}).withStyle(ChatFormatting.YELLOW));
        } else {
            components.add((Component)Component.translatable((String)"detonator.no_pos").withStyle(ChatFormatting.RED));
        }
    }
}

