/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tools;

import api.hbm.item.IDepthRockTool;
import com.hbm.config.MainConfig;
import com.hbm.handler.KeyHandler;
import com.hbm.handler.ability.AvailableAbilities;
import com.hbm.handler.ability.IBaseAbility;
import com.hbm.handler.ability.IToolAreaAbility;
import com.hbm.handler.ability.IToolHarvestAbility;
import com.hbm.handler.ability.ToolPreset;
import com.hbm.inventory.screens.ToolAbilityScreen;
import com.hbm.items.IItemControlReceiver;
import com.hbm.items.IItemHUD;
import com.hbm.items.IKeybindReceiver;
import com.hbm.network.toclient.InformPlayer;
import com.hbm.util.TagsUtilDegradation;
import com.hbm.util.Tuple;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;

public class ToolAbilityItem
extends TieredItem
implements IDepthRockTool,
IItemControlReceiver,
IItemHUD,
IKeybindReceiver {
    protected AvailableAbilities availableAbilities = new AvailableAbilities().addToolAbilities();
    private boolean rockBreaker;
    private boolean isShears;
    private static final Map<IBaseAbility, Tuple.Pair<Integer, Integer>> abilityGui = new HashMap<IBaseAbility, Tuple.Pair<Integer, Integer>>();

    public ToolAbilityItem setShears() {
        this.isShears = true;
        return this;
    }

    public ToolAbilityItem(Item.Properties properties, Tier tier, float damage, float attackSpeed) {
        super(tier, properties.component(DataComponents.TOOL, (Object)tier.createToolProperties(BlockTags.MINEABLE_WITH_PICKAXE)).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)(damage + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public ToolAbilityItem addAbility(IBaseAbility ability, int level) {
        this.availableAbilities.addAbility(ability, level);
        return this;
    }

    public ToolAbilityItem setDepthRockBreaker() {
        this.rockBreaker = true;
        return this;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity victim, LivingEntity attacker) {
        if (!attacker.level().isClientSide && attacker instanceof Player) {
            Player player = (Player)attacker;
            if (this.canOperate(stack)) {
                this.availableAbilities.getWeaponAbilities().forEach((ability, level) -> ability.onHit((int)level, attacker.level(), player, (Entity)victim, (Item)this));
            }
        }
        return true;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_PICKAXE_ACTIONS.contains(itemAbility);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        Player player;
        if (!level.isClientSide && miningEntity instanceof Player && (this.canHarvest(stack, state, player = (Player)miningEntity, level, pos) || this.canShearBlock(state, stack, level, pos)) && this.canOperate(stack)) {
            Configuration config = this.getConfiguration(stack);
            ToolPreset preset = config.getActivePreset();
            boolean harvestAllowed = preset.harvestAbility.isAllowed();
            boolean areaAllowed = preset.areaAbility.isAllowed();
            if (harvestAllowed) {
                preset.harvestAbility.preHarvestAll(preset.harvestAbilityLevel, level, player, stack);
            }
            if (areaAllowed) {
                preset.areaAbility.onDig(preset.areaAbilityLevel, level, pos, player, this);
            }
            if (harvestAllowed) {
                preset.harvestAbility.postHarvestAll(preset.harvestAbilityLevel, level, player, stack);
            }
        }
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (!this.canOperate(stack)) {
            return 1.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean canOperate(ItemStack stack) {
        return true;
    }

    public boolean canHarvest(ItemStack stack, BlockState state, Player player, Level level, BlockPos pos) {
        if (!this.canOperate(stack)) {
            return false;
        }
        if (this.getConfiguration((ItemStack)stack).getActivePreset().harvestAbility == IToolHarvestAbility.SILK) {
            return true;
        }
        return EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)state, (BlockGetter)level, (BlockPos)pos) && this.getDestroySpeed(stack, state) > 1.0f;
    }

    public boolean canBreakRock(Level level, Player player, ItemStack tool, BlockState state, BlockPos pos) {
        return this.canOperate(tool) && this.rockBreaker;
    }

    public boolean canShearBlock(BlockState state, ItemStack stack, Level level, BlockPos pos) {
        IShearable shearable;
        Block block;
        return this.isShears(stack) && (block = state.getBlock()) instanceof IShearable && (shearable = (IShearable)block).isShearable(null, stack, level, pos);
    }

    public boolean isShears(ItemStack stack) {
        return this.isShears;
    }

    @Override
    public boolean canBreakRock(Level level, Player player, ItemStack tool, Block block, BlockPos pos) {
        return this.canOperate(tool) && this.rockBreaker;
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || !this.getConfiguration(stack).getActivePreset().isNone();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        this.availableAbilities.appendHoverText(tooltipComponents);
        if (this.rockBreaker) {
            tooltipComponents.add((Component)Component.empty());
            tooltipComponents.add((Component)Component.literal((String)"Can break depth rock!").withStyle(ChatFormatting.RED));
        }
    }

    public void breakExtraBlock(Level level, BlockPos pos, Player player, BlockPos refPos) {
        Configuration config = this.getConfiguration(player.getMainHandItem());
        ToolPreset preset = config.getActivePreset();
        preset.harvestAbility.onHarvestBlock(level, pos, player, refPos);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!this.canOperate(player.getItemInHand(usedHand))) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        Configuration config = this.getConfiguration(player.getItemInHand(usedHand));
        if (config.presets.size() < 2 || level.isClientSide) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        config.currentPreset = player.isCrouching() ? 0 : (config.currentPreset + 1) % config.presets.size();
        this.setConfiguration(player.getItemInHand(usedHand), config);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new InformPlayer(config.getActivePreset().getMessage(), 11, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.25f, config.getActivePreset().isNone() ? 0.75f : 1.25f);
        return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
    }

    @Override
    public boolean canHandleKeybind(Player player, ItemStack stack, KeyHandler.EnumKeybind keybind) {
        return keybind == KeyHandler.EnumKeybind.ABILITY_CYCLE || keybind == KeyHandler.EnumKeybind.ABILITY_ALT;
    }

    @Override
    public void handleKeybind(Player player, ItemStack stack, KeyHandler.EnumKeybind keybind, boolean state) {
        if (keybind == KeyHandler.EnumKeybind.ABILITY_CYCLE && state) {
            if (!this.canOperate(stack)) {
                return;
            }
            Configuration config = this.getConfiguration(stack);
            if (config.presets.size() < 2) {
                return;
            }
            config.currentPreset = player.isCrouching() ? 0 : (config.currentPreset + 1) % config.presets.size();
            this.setConfiguration(stack, config);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new InformPlayer(config.getActivePreset().getMessage(), 11, 1000), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.25f, config.getActivePreset().isNone() ? 0.75f : 1.25f);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleKeybindClient(LocalPlayer player, ItemStack stack, KeyHandler.EnumKeybind keybind, boolean state) {
        if (keybind == KeyHandler.EnumKeybind.ABILITY_ALT && state) {
            Minecraft.getInstance().setScreen((Screen)new ToolAbilityScreen(this.availableAbilities));
        }
    }

    public Configuration getConfiguration(ItemStack stack) {
        Configuration config = new Configuration();
        if (stack.isEmpty() || !TagsUtilDegradation.containsAnyTag(stack) || !TagsUtilDegradation.getTag(stack).contains("ability") || !TagsUtilDegradation.getTag(stack).contains("abilityPresets")) {
            config.reset(this.availableAbilities);
            return config;
        }
        config.readFromNBT(TagsUtilDegradation.getTag(stack));
        config.restrictTo(this.availableAbilities);
        return config;
    }

    public void setConfiguration(ItemStack stack, Configuration config) {
        if (stack.isEmpty()) {
            return;
        }
        CompoundTag tag = TagsUtilDegradation.getTag(stack);
        config.writeToNBT(tag);
        TagsUtilDegradation.putTag(stack, tag);
    }

    @Override
    public void receiveControl(ItemStack stack, CompoundTag tag) {
        Configuration config = new Configuration();
        config.readFromNBT(tag);
        config.restrictTo(this.availableAbilities);
        this.setConfiguration(stack, config);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(RenderGuiEvent.Pre event, Player player, ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        Options options = mc.options;
        if (!options.getCameraType().isFirstPerson()) {
            return;
        }
        if (options.hideGui) {
            return;
        }
        if (mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        Configuration config = this.getConfiguration(stack);
        ToolPreset preset = config.getActivePreset();
        Tuple.Pair<Integer, Integer> uv = abilityGui.get(preset.areaAbility);
        if (uv == null) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int size = 16;
        int ox = (Integer)MainConfig.CLIENT.TOOL_HUD_INDICATOR_X.get();
        int oy = (Integer)MainConfig.CLIENT.TOOL_HUD_INDICATOR_Y.get();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        guiGraphics.blit(ToolAbilityScreen.TEXTURE, mc.getWindow().getGuiScaledWidth() / 2 - size - 8 + ox, mc.getWindow().getGuiScaledHeight() / 2 + 8 + oy, size, size, (float)((Integer)uv.key).intValue(), (float)((Integer)uv.value).intValue(), size, size, 256, 256);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }

    static {
        abilityGui.put(IToolAreaAbility.RECURSION, new Tuple.Pair<Integer, Integer>(48, 138));
        abilityGui.put(IToolAreaAbility.HAMMER, new Tuple.Pair<Integer, Integer>(80, 138));
        abilityGui.put(IToolAreaAbility.HAMMER_FLAT, new Tuple.Pair<Integer, Integer>(112, 138));
        abilityGui.put(IToolAreaAbility.EXPLOSION, new Tuple.Pair<Integer, Integer>(144, 138));
    }

    public static class Configuration {
        public List<ToolPreset> presets;
        public int currentPreset;

        public Configuration() {
            this.presets = null;
            this.currentPreset = 0;
        }

        public Configuration(List<ToolPreset> presets, int currentPreset) {
            this.presets = presets;
            this.currentPreset = currentPreset;
        }

        public void writeToNBT(CompoundTag tag) {
            tag.putInt("ability", this.currentPreset);
            ListTag listPresets = new ListTag();
            for (ToolPreset preset : this.presets) {
                CompoundTag tagPreset = new CompoundTag();
                preset.writeToNBT(tagPreset);
                listPresets.add((Object)tagPreset);
            }
            tag.put("abilityPresets", (Tag)listPresets);
        }

        public void readFromNBT(CompoundTag tag) {
            this.currentPreset = tag.getInt("ability");
            ListTag listPresets = tag.getList("abilityPresets", 10);
            int numPresets = Math.min(listPresets.size(), 99);
            this.presets = new ArrayList<ToolPreset>(numPresets);
            for (int i = 0; i < numPresets; ++i) {
                CompoundTag tagPreset = listPresets.getCompound(i);
                ToolPreset preset = new ToolPreset();
                preset.readFromNBT(tagPreset);
                this.presets.add(preset);
            }
            this.currentPreset = Math.max(0, Math.min(this.currentPreset, this.presets.size() - 1));
        }

        public void reset(AvailableAbilities availableAbilities) {
            this.currentPreset = 0;
            this.presets = new ArrayList<ToolPreset>(availableAbilities.size());
            this.presets.add(new ToolPreset());
            availableAbilities.getToolAreaAbilities().forEach((ability, level) -> {
                if (ability == IToolAreaAbility.NONE) {
                    return;
                }
                this.presets.add(new ToolPreset((IToolAreaAbility)ability, (int)level, IToolHarvestAbility.NONE, 0));
            });
            availableAbilities.getToolHarvestAbilities().forEach((ability, level) -> {
                if (ability == IToolHarvestAbility.NONE) {
                    return;
                }
                this.presets.add(new ToolPreset(IToolAreaAbility.NONE, 0, (IToolHarvestAbility)ability, (int)level));
            });
            this.presets.sort(Comparator.comparing(p -> p.harvestAbility).thenComparingInt(p -> p.harvestAbilityLevel).thenComparing(p -> p.areaAbility).thenComparingInt(p -> p.areaAbilityLevel));
        }

        public void restrictTo(AvailableAbilities availableAbilities) {
            for (ToolPreset preset : this.presets) {
                preset.restrictTo(availableAbilities);
            }
        }

        public ToolPreset getActivePreset() {
            return this.presets.get(this.currentPreset);
        }
    }
}

