/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tools;

import api.hbm.block.IToolable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class ToolingItem
extends Item {
    protected IToolable.ToolType type;

    public ToolingItem(IToolable.ToolType type, Item.Properties properties) {
        super(properties.stacksTo(1));
        this.type = type;
        type.register(new ItemStack((ItemLike)this));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos usedPos = context.getClickedPos();
        Direction usedDirection = context.getClickedFace();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Block block = level.getBlockState(usedPos).getBlock();
        if (block instanceof IToolable) {
            IToolable toolableBlock = (IToolable)block;
            toolableBlock.onScrew(level, player, usedPos, usedDirection, this.type);
            if (this.getMaxDamage(new ItemStack((ItemLike)this)) > 0) {
                context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

