/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.factory;

import com.hbm.lib.ModSounds;
import com.hbm.network.toclient.AuxParticle;
import com.hbm.particle.helper.AshesCreator;
import com.hbm.particle.helper.SkeletonCreator;
import com.hbm.util.DamageSourceNT;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConfettiUtil {
    public static void decideConfetti(LivingEntity entity, DamageSourceNT source) {
        if (entity.isAlive()) {
            return;
        }
        if (source.isExplosion()) {
            ConfettiUtil.gib(entity);
        }
        if (source.isFireDamage()) {
            ConfettiUtil.cremate(entity);
        }
    }

    public static void pulverize(LivingEntity entity) {
        int amount = Mth.clamp((int)((int)(entity.getBbWidth() * entity.getBbHeight() * entity.getBbWidth() * 25.0f)), (int)5, (int)50);
        AshesCreator.composeEffect(entity.level(), (Entity)entity, amount, 0.125f);
        SkeletonCreator.composeEffect(entity.level(), (Entity)entity, 1.0f);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), ModSounds.FIRE_DISINTEGRATION, SoundSource.AMBIENT, 2.0f, 0.9f + entity.getRandom().nextFloat() * 0.2f);
    }

    public static void cremate(LivingEntity entity) {
        int amount = Mth.clamp((int)((int)(entity.getBbWidth() * entity.getBbHeight() * entity.getBbWidth() * 25.0f)), (int)5, (int)50);
        AshesCreator.composeEffect(entity.level(), (Entity)entity, amount, 0.125f);
        SkeletonCreator.composeEffect(entity.level(), (Entity)entity, 0.25f);
        entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), ModSounds.FIRE_DISINTEGRATION, SoundSource.AMBIENT, 2.0f, 0.9f + entity.getRandom().nextFloat() * 0.2f);
    }

    public static void gib(LivingEntity entity) {
        if (entity instanceof Slime) {
            return;
        }
        SkeletonCreator.composeEffectGib(entity.level(), (Entity)entity, 0.25f);
        if (entity instanceof Skeleton) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        tag.putString("type", "giblets");
        tag.putInt("ent", entity.getId());
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersNear((ServerLevel)serverLevel, null, (double)entity.getX(), (double)(entity.getY() + (double)entity.getBbHeight() * 0.5), (double)entity.getZ(), (double)150.0, (CustomPacketPayload)new AuxParticle(tag, entity.getX(), entity.getY() + (double)entity.getBbHeight() * 0.5, entity.getZ()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            serverLevel.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR, SoundSource.BLOCKS, 2.0f, 0.95f + entity.getRandom().nextFloat() * 0.2f);
        }
    }
}

