/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.toclient;

import com.hbm.HBMsNTMClient;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record InformPlayer(Component component, int id, int millis) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<InformPlayer> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"inform_player"));
    public static final StreamCodec<RegistryFriendlyByteBuf, InformPlayer> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, InformPlayer>(){

        public InformPlayer decode(RegistryFriendlyByteBuf buf) {
            int id = buf.readInt();
            int millis = buf.readInt();
            return new InformPlayer((Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf), id, millis);
        }

        public void encode(RegistryFriendlyByteBuf buf, InformPlayer packet) {
            buf.writeInt(packet.id);
            buf.writeInt(packet.millis);
            ComponentSerialization.STREAM_CODEC.encode((Object)buf, (Object)packet.component);
        }
    };

    public static void handleClient(InformPlayer packet, IPayloadContext context) {
        context.enqueueWork(() -> HBMsNTMClient.displayTooltip(packet.component(), packet.millis(), packet.id()));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

