/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.toclient;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ParticleBurst(BlockPos pos, Block block) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ParticleBurst> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"particle_burst"));
    public static final StreamCodec<FriendlyByteBuf, ParticleBurst> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, ParticleBurst>(){

        public ParticleBurst decode(FriendlyByteBuf buf) {
            BlockPos pos = buf.readBlockPos();
            ResourceLocation id = buf.readResourceLocation();
            Block block = (Block)BuiltInRegistries.BLOCK.get(id);
            return new ParticleBurst(pos, block);
        }

        public void encode(FriendlyByteBuf buf, ParticleBurst packet) {
            buf.writeBlockPos(packet.pos());
            buf.writeResourceLocation(BuiltInRegistries.BLOCK.getKey((Object)packet.block()));
        }
    };

    public static void handleClient(ParticleBurst packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            BlockState state = packet.block().defaultBlockState();
            Minecraft.getInstance().particleEngine.destroy(packet.pos(), state);
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

