/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.toclient;

import com.hbm.items.tools.SatelliteInterfaceItem;
import com.hbm.saveddata.satellite.Satellite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SatellitePanel(int satType, CompoundTag tag) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SatellitePanel> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"sat_panel"));
    public static final StreamCodec<FriendlyByteBuf, SatellitePanel> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, SatellitePanel>(){

        public SatellitePanel decode(FriendlyByteBuf buf) {
            int type = buf.readInt();
            CompoundTag nbt = buf.readNbt();
            return new SatellitePanel(type, nbt);
        }

        public void encode(FriendlyByteBuf buf, SatellitePanel packet) {
            buf.writeInt(packet.satType);
            buf.writeNbt((Tag)packet.tag);
        }
    };

    public static void handleClient(SatellitePanel packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            CompoundTag tag = packet.tag;
            SatelliteInterfaceItem.currentSat = Satellite.create(packet.satType);
            if (tag != null) {
                SatelliteInterfaceItem.currentSat.readFromNBT(tag);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

