/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.toserver;

import com.hbm.extprop.HbmPlayerAttachments;
import com.hbm.handler.KeyHandler;
import com.hbm.items.IKeybindReceiver;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record KeybindReceiver(KeyHandler.EnumKeybind keybind, boolean state, boolean property) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<KeybindReceiver> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"keybind"));
    public static final StreamCodec<FriendlyByteBuf, KeybindReceiver> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, KeybindReceiver>(){

        public KeybindReceiver decode(FriendlyByteBuf buf) {
            KeyHandler.EnumKeybind key = (KeyHandler.EnumKeybind)buf.readEnum(KeyHandler.EnumKeybind.class);
            boolean state = buf.readBoolean();
            boolean property = buf.readBoolean();
            return new KeybindReceiver(key, state, property);
        }

        public void encode(FriendlyByteBuf buf, KeybindReceiver packet) {
            buf.writeEnum((Enum)packet.keybind);
            buf.writeBoolean(packet.state);
            buf.writeBoolean(packet.property);
        }
    };

    public static void handleServer(KeybindReceiver packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            if (packet.property) {
                HbmPlayerAttachments props = HbmPlayerAttachments.getData((Player)player);
                props.setKeyPressed((Player)player, packet.keybind(), packet.state());
            }
            if (!packet.property) {
                for (ItemStack stack : new ItemStack[]{player.getMainHandItem(), player.getOffhandItem()}) {
                    IKeybindReceiver receiver;
                    Item patt1$temp = stack.getItem();
                    if (!(patt1$temp instanceof IKeybindReceiver) || !(receiver = (IKeybindReceiver)patt1$temp).canHandleKeybind((Player)player, stack, packet.keybind())) continue;
                    receiver.handleKeybind((Player)player, stack, packet.keybind(), packet.state());
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

