/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.network.toserver;

import com.hbm.items.ISatChip;
import com.hbm.items.tools.SatelliteInterfaceItem;
import com.hbm.saveddata.SatelliteSavedData;
import com.hbm.saveddata.satellite.Satellite;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SatelliteLaser(int x, int z, int freq) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SatelliteLaser> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"sat_laser"));
    public static final StreamCodec<FriendlyByteBuf, SatelliteLaser> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, SatelliteLaser>(){

        public SatelliteLaser decode(FriendlyByteBuf buf) {
            return new SatelliteLaser(buf.readInt(), buf.readInt(), buf.readInt());
        }

        public void encode(FriendlyByteBuf buf, SatelliteLaser packet) {
            buf.writeInt(packet.x);
            buf.writeInt(packet.z);
            buf.writeInt(packet.freq);
        }
    };

    public static void handleServer(SatelliteLaser packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Satellite sat;
            int freq;
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
            if (serverPlayer.getMainHandItem().getItem() instanceof SatelliteInterfaceItem && (freq = ISatChip.getFreqS(serverPlayer.getMainHandItem())) == packet.freq && (sat = SatelliteSavedData.get((ServerLevel)context.player().level()).getSatFromFreq(packet.freq)) != null) {
                sat.onClick(context.player().level(), packet.x, packet.z);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

