/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.CustomRenderType;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class AmatFlashParticle
extends TextureSheetParticle {
    public AmatFlashParticle(ClientLevel level, double x, double y, double z, float size) {
        super(level, x, y, z);
        this.lifetime = 10;
        this.quadSize = size;
    }

    public void render(VertexConsumer ignored, Camera camera, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        Vec3 cameraPosition = camera.getPosition();
        float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x);
        float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y);
        float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z);
        poseStack.pushPose();
        poseStack.translate(pX, pY, pZ);
        poseStack.scale(0.2f * this.quadSize, 0.2f * this.quadSize, 0.2f * this.quadSize);
        float intensity = ((float)this.age + partialTicks) / (float)this.lifetime;
        float inverse = Math.clamp(1.0f - intensity, 0.0f, 1.0f);
        Tesselator tess = Tesselator.getInstance();
        RandomSource random = RandomSource.create((long)432L);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        float scale = 0.5f;
        for (int i = 0; i < 100; ++i) {
            poseStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.ZP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(random.nextFloat() * 360.0f));
            poseStack.mulPose(Axis.YP.rotationDegrees(random.nextFloat() * 360.0f));
            float vert1 = (random.nextFloat() * 20.0f + 5.0f + 10.0f) * (intensity * scale);
            float vert2 = (random.nextFloat() * 2.0f + 1.0f + 2.0f) * (intensity * scale);
            BufferBuilder buffer = tess.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            Matrix4f matrix = poseStack.last().pose();
            buffer.addVertex(matrix, 0.0f, 0.0f, 0.0f).setColor(1.0f, 1.0f, 1.0f, inverse);
            buffer.addVertex(matrix, -0.866f * vert2, vert1, -0.5f * vert2).setColor(1.0f, 1.0f, 1.0f, 0.0f);
            buffer.addVertex(matrix, 0.866f * vert2, vert1, -0.5f * vert2).setColor(1.0f, 1.0f, 1.0f, 0.0f);
            buffer.addVertex(matrix, 0.0f, vert1, 1.0f * vert2).setColor(1.0f, 1.0f, 1.0f, 0.0f);
            buffer.addVertex(matrix, -0.866f * vert2, vert1, -0.5f * vert2).setColor(1.0f, 1.0f, 1.0f, 0.0f);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        poseStack.popPose();
    }

    public ParticleRenderType getRenderType() {
        return CustomRenderType.NONE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double dx, double dy, double dz) {
            return new AmatFlashParticle(world, x, y, z, 1.0f);
        }
    }
}

