/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.ModParticles;
import com.hbm.particle.RotatingParticle;
import com.hbm.util.Vec3NT;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AshesParticle
extends RotatingParticle {
    protected double prevRotationPitch;
    protected double rotationPitch;
    private static final double MAXIMUM_COLLISION_VELOCITY_SQUARED = Mth.square((double)100.0);

    public AshesParticle(ClientLevel level, double x, double y, double z, float scale) {
        super(level, x, y, z);
        this.setSpriteFromAge(ModParticles.BASE_PARTICLE_SPRITES);
        this.lifetime = 1200 + this.random.nextInt(20);
        this.quadSize = scale * 0.9f + this.random.nextFloat() * 0.2f;
        this.gravity = 0.01f;
        this.gCol = this.bCol = this.random.nextFloat() * 0.1f + 0.1f;
        this.rCol = this.bCol;
    }

    public void move(double x, double y, double z) {
        double d0 = x;
        double d1 = y;
        double d2 = z;
        if (this.hasPhysics && (x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < MAXIMUM_COLLISION_VELOCITY_SQUARED) {
            Vec3 vec3 = Entity.collideBoundingBox(null, (Vec3)new Vec3(x, y, z), (AABB)this.getBoundingBox(), (Level)this.level, List.of());
            x = vec3.x;
            y = vec3.y;
            z = vec3.z;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.setBoundingBox(this.getBoundingBox().move(x, y, z));
            this.setLocationFromBoundingbox();
        }
        boolean bl = this.onGround = d1 != y && d1 < 0.0;
        if (this.onGround) {
            this.xd = 0.0;
            this.yd = 0.0;
            this.zd = 0.0;
        } else {
            if (d0 != x) {
                this.xd = 0.0;
            }
            if (d2 != z) {
                this.zd = 0.0;
            }
        }
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.yd -= (double)this.gravity;
        this.prevRotationPitch = this.rotationPitch;
        if (!this.onGround) {
            this.rotationPitch += (double)((float)(2.0 * ((double)(((Object)((Object)this)).hashCode() % 2) - 0.5)));
        }
        this.xd *= 0.95;
        this.yd *= 0.99;
        this.zd *= 0.95;
        boolean wasOnGround = this.onGround;
        this.move(this.xd, this.yd, this.zd);
        if (!wasOnGround && this.onGround) {
            this.rotationPitch = this.random.nextFloat() * 360.0f;
        }
        if (((Object)((Object)this)).hashCode() % 5 == 0 && this.onGround && this.random.nextInt(15) == 0) {
            this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, this.x, this.y + 0.125, this.z, 0.0, 0.05, 0.0);
        }
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        float timeLeft = (float)this.lifetime - ((float)this.age + partialTicks);
        this.alpha = timeLeft < 40.0f ? timeLeft / 40.0f : 1.0f;
        if (this.onGround) {
            float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x);
            float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y);
            float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z);
            Vec3NT vec = new Vec3NT(this.quadSize, 0.0, this.quadSize).rotateAroundYDeg(this.rotationPitch);
            float u0 = this.sprite.getU0();
            float u1 = this.sprite.getU1();
            float v0 = this.sprite.getV0();
            float v1 = this.sprite.getV1();
            int light = this.getLightColor(partialTicks);
            consumer.addVertex((float)((double)pX + vec.xCoord), pY + 0.15f, (float)((double)pZ + vec.zCoord)).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(light);
            vec.rotateAroundYDeg(90.0);
            consumer.addVertex((float)((double)pX + vec.xCoord), pY + 0.15f, (float)((double)pZ + vec.zCoord)).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(light);
            vec.rotateAroundYDeg(90.0);
            consumer.addVertex((float)((double)pX + vec.xCoord), pY + 0.15f, (float)((double)pZ + vec.zCoord)).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(light);
            vec.rotateAroundYDeg(90.0);
            consumer.addVertex((float)((double)pX + vec.xCoord), pY + 0.15f, (float)((double)pZ + vec.zCoord)).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setNormal(0.0f, 1.0f, 0.0f).setLight(light);
        } else {
            this.renderParticleRotated(consumer, camera, this.rCol, this.gCol, this.bCol, this.alpha, this.quadSize, partialTicks, this.getLightColor(partialTicks));
        }
    }

    @Override
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public TextureSheetParticle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double dx, double dy, double dz) {
            return new AshesParticle(world, x, y, z, 0.125f);
        }
    }
}

