/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.ModParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class CoolingTowerParticle
extends TextureSheetParticle {
    private float baseScale = 1.0f;
    private float maxScale = 1.0f;
    private float lift = 0.3f;
    private float strafe = 0.075f;
    private boolean windDir = true;
    private float alphaMod = 0.25f;

    public CoolingTowerParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.gCol = this.bCol = 0.9f + level.random.nextFloat() * 0.05f;
        this.rCol = this.bCol;
        this.hasPhysics = false;
        this.setSpriteFromAge(ModParticles.BASE_PARTICLE_SPRITES);
    }

    public void setBaseScale(float f) {
        this.baseScale = f;
    }

    public void setMaxScale(float f) {
        this.maxScale = f;
    }

    public void setLift(float f) {
        this.lift = f;
    }

    public void setLife(int i) {
        this.lifetime = i;
    }

    public void setStrafe(float f) {
        this.strafe = f;
    }

    public void noWind() {
        this.windDir = false;
    }

    public void alphaMod(float mod) {
        this.alphaMod = mod;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        float ageScale = (float)this.age / (float)this.lifetime;
        this.alpha = this.alphaMod - ageScale * this.alphaMod;
        this.quadSize = this.baseScale + (float)Math.pow(this.maxScale * ageScale - this.baseScale, 2.0);
        if (this.lift > 0.0f && this.yd < (double)this.lift) {
            this.yd += (double)0.01f;
        }
        if (this.lift < 0.0f && this.yd > (double)this.lift) {
            this.yd -= (double)0.01f;
        }
        this.xd += this.random.nextGaussian() * (double)this.strafe * (double)ageScale;
        this.zd += this.random.nextGaussian() * (double)this.strafe * (double)ageScale;
        if (this.windDir) {
            this.xd += 0.02 * (double)ageScale;
            this.zd -= 0.01 * (double)ageScale;
        }
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        this.xd *= 0.925;
        this.yd *= 0.925;
        this.zd *= 0.925;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new CoolingTowerParticle(level, x, y, z);
        }
    }
}

