/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.ModParticles;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DigammaSmokeParticle
extends TextureSheetParticle {
    public DigammaSmokeParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.setSpriteFromAge(ModParticles.BASE_PARTICLE_SPRITES);
        this.lifetime = 100 + this.random.nextInt(40);
        this.hasPhysics = false;
        this.quadSize = 5.0f;
        this.rCol = 0.5f + this.random.nextFloat() * 0.2f;
        this.gCol = 0.0f;
        this.bCol = 0.0f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        if (this.age == this.lifetime) {
            this.remove();
        }
        this.xd *= 0.99;
        this.yd *= 0.99;
        this.zd *= 0.99;
        this.move(this.xd, this.yd, this.zd);
    }

    public void render(VertexConsumer ignored, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x);
        float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y);
        float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        this.alpha = Math.clamp(1.0f - ((float)this.age + partialTicks) / (float)this.lifetime, 0.0f, 1.0f);
        Vector3f l = new Vector3f((Vector3fc)camera.getLeftVector()).mul(this.quadSize);
        Vector3f u = new Vector3f((Vector3fc)camera.getUpVector()).mul(this.quadSize);
        float u0 = this.sprite.getU0();
        float u1 = this.sprite.getU1();
        float v0 = this.sprite.getV0();
        float v1 = this.sprite.getV1();
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder buf = tess.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        buf.addVertex(pX - l.x - u.x, pY - l.y - u.y, pZ - l.z - u.z).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
        buf.addVertex(pX - l.x + u.x, pY - l.y + u.y, pZ - l.z + u.z).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
        buf.addVertex(pX + l.x + u.x, pY + l.y + u.y, pZ + l.z + u.z).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
        buf.addVertex(pX + l.x - u.x, pY + l.y - u.y, pZ + l.z - u.z).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
        BufferUploader.drawWithShader((MeshData)buf.buildOrThrow());
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new DigammaSmokeParticle(level, x, y, z);
        }
    }
}

