/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.CustomRenderType;
import com.hbm.particle.ModParticles;
import com.hbm.render.CustomRenderTypes;
import com.hbm.util.old.TessColorUtil;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class HazeParticle
extends TextureSheetParticle {
    private static final ResourceLocation HAZE = ResourceLocation.fromNamespaceAndPath((String)"hbmsntm", (String)"textures/particle/haze.png");

    public HazeParticle(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.setSpriteFromAge(ModParticles.HAZE_SPRITES);
        this.lifetime = 600 + this.random.nextInt(100);
        this.quadSize = 10.0f;
        this.alpha = 0.0f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        ++this.age;
        if (this.age >= this.lifetime) {
            this.remove();
        }
        this.xd *= 0.96;
        this.yd *= 0.96;
        this.zd *= 0.96;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
        int x = (int)Math.floor(this.x) + this.random.nextInt(15) - 7;
        int z = (int)Math.floor(this.y) + this.random.nextInt(15) - 7;
        int y = this.level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
        this.level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)x + this.random.nextDouble(), (double)y + 0.1, (double)z + this.random.nextDouble(), 0.0, 0.0, 0.0);
    }

    public void render(VertexConsumer ignored, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        float alpha = 0.0f;
        alpha = (float)Math.sin((double)this.age * Math.PI / 400.0) * 0.25f;
        int color = TessColorUtil.getColorRGBA_F(1.0f, 1.0f, 1.0f, alpha * 0.1f);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer consumer = bufferSource.getBuffer(CustomRenderTypes.entitySmoth(HAZE));
        Random rand = new Random(50L);
        Vector3f up = new Vector3f((Vector3fc)camera.getUpVector());
        Vector3f left = new Vector3f((Vector3fc)camera.getLeftVector());
        for (int i = 0; i < 25; ++i) {
            double dX = rand.nextGaussian() * 2.5;
            double dY = rand.nextGaussian() * 0.15;
            double dZ = rand.nextGaussian() * 2.5;
            float size = (rand.nextFloat() * 0.25f + 0.75f) * this.quadSize;
            float pX = (float)((double)((float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x)) + dX + rand.nextGaussian() * 0.5);
            float pY = (float)((double)((float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y)) + dY + rand.nextGaussian() * 0.5);
            float pZ = (float)((double)((float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z)) + dZ + rand.nextGaussian() * 0.5);
            this.renderQuad(consumer, pX, pY, pZ, up, left, size, color);
        }
    }

    private void renderQuad(VertexConsumer consumer, float pX, float pY, float pZ, Vector3f up, Vector3f left, float scale, int color) {
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        Vector3f l = new Vector3f((Vector3fc)left).mul(scale);
        Vector3f u = new Vector3f((Vector3fc)up).mul(scale);
        consumer.addVertex(pX - l.x - u.x, pY - l.y - u.y, pZ - l.z - u.z).setColor(color).setUv(u1, v1).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX - l.x + u.x, pY - l.y + u.y, pZ - l.z + u.z).setColor(color).setUv(u1, v0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX + l.x + u.x, pY + l.y + u.y, pZ + l.z + u.z).setColor(color).setUv(u0, v0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX + l.x - u.x, pY + l.y - u.y, pZ + l.z - u.z).setColor(color).setUv(u0, v1).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
    }

    public ParticleRenderType getRenderType() {
        return CustomRenderType.FOG;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet sprites) {
            ModParticles.HAZE_SPRITES = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new HazeParticle(level, x, y, z);
        }
    }
}

