/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.ParticleRocketFlame;
import com.hbm.wiaj.WorldInAJar;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class ParticleDebris
extends TextureSheetParticle {
    private final BlockRenderDispatcher blockRenderer;
    private WorldInAJar world;
    private static final Random rng = new Random();

    public ParticleDebris(ClientLevel level, double x, double y, double z, double mx, double my, double mz) {
        super(level, x, y, z);
        double mult = 3.0;
        this.xd = mx * mult;
        this.yd = my * mult;
        this.zd = mz * mult;
        this.lifetime = 100;
        this.gravity = 0.15f;
        this.hasPhysics = false;
        this.blockRenderer = Minecraft.getInstance().getBlockRenderer();
        this.world = new WorldInAJar(4, 4, 4);
    }

    public ParticleDebris setWorldInAJar(WorldInAJar world) {
        this.world = world;
        return this;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age > 5) {
            this.hasPhysics = true;
        }
        rng.setSeed(((Object)((Object)this)).hashCode());
        this.oRoll = this.roll;
        this.roll += rng.nextFloat() * 10.0f;
        if (((Object)((Object)this)).hashCode() % 3 == 0) {
            ParticleRocketFlame particle = new ParticleRocketFlame(this.level, this.x, this.y, this.z);
            particle.setScale(1.0f * (float)Math.max(this.world.sizeY, 6) / 16.0f);
            particle.resetPrevPos();
            particle.setMaxAge(50);
            Minecraft.getInstance().particleEngine.add((Particle)particle);
        }
        this.yd -= (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        ++this.age;
        if (this.onGround) {
            this.remove();
        }
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        PoseStack pose = new PoseStack();
        double camX = camera.getPosition().x;
        double camY = camera.getPosition().y;
        double camZ = camera.getPosition().z;
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        int blockLight = this.level.getBrightness(LightLayer.BLOCK, pos);
        int skyLight = this.level.getBrightness(LightLayer.SKY, pos);
        int packedLight = LightTexture.pack((int)blockLight, (int)skyLight);
        double interpX = Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x);
        double interpY = Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y);
        double interpZ = Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z);
        pose.pushPose();
        pose.translate(interpX - camX, interpY - camY, interpZ - camZ);
        pose.translate((double)this.world.sizeX / -2.0, (double)this.world.sizeY / -2.0, (double)this.world.sizeZ / -2.0);
        float angle = this.oRoll + (this.roll - this.oRoll) * partialTicks;
        pose.translate((double)this.world.sizeX / 2.0, (double)this.world.sizeY / 2.0, (double)this.world.sizeZ / 2.0);
        pose.mulPose(Axis.YP.rotationDegrees(angle));
        pose.mulPose(Axis.XP.rotationDegrees(angle * 0.5f));
        pose.translate((double)(-this.world.sizeX) / 2.0, (double)(-this.world.sizeY) / 2.0, (double)(-this.world.sizeZ) / 2.0);
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        for (int ix = 0; ix < this.world.sizeX; ++ix) {
            for (int iy = 0; iy < this.world.sizeY; ++iy) {
                for (int iz = 0; iz < this.world.sizeZ; ++iz) {
                    BlockState state = this.world.getBlock(ix, iy, iz);
                    if (state.isAir()) continue;
                    pose.pushPose();
                    pose.translate((float)ix, (float)iy, (float)iz);
                    this.blockRenderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)this.level, this.blockRenderer.getBlockModel(state), state, pos.offset(ix, iy, iz), pose, bufferSource.getBuffer(RenderType.cutout()), false, this.level.random, 42L, packedLight, ModelData.EMPTY, RenderType.cutout());
                    pose.popPose();
                }
            }
        }
        pose.popPose();
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new ParticleDebris(level, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

