/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.ModParticles;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ParticleExSmoke
extends TextureSheetParticle {
    private int age;
    public int maxAge;

    public ParticleExSmoke(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.maxAge = 100 + this.random.nextInt(40);
        this.setSpriteFromAge(ModParticles.BASE_PARTICLE_SPRITES);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.alpha = 1.0f - (float)this.age / (float)this.maxAge;
        ++this.age;
        if (this.age == this.maxAge) {
            this.remove();
        }
        this.xd *= 0.76;
        this.yd *= 0.76;
        this.zd *= 0.76;
        this.move(this.xd, this.yd, this.zd);
    }

    public ParticleExSmoke setMotionX(double motionX) {
        this.xd = motionX;
        return this;
    }

    public ParticleExSmoke setMotionY(double motionY) {
        this.yd = motionY;
        return this;
    }

    public ParticleExSmoke setMotionZ(double motionZ) {
        this.zd = motionZ;
        return this;
    }

    public double getMotionY() {
        return this.yd;
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Quaternionf quaternionf = new Quaternionf((Quaternionfc)camera.rotation());
        Vec3 camPos = camera.getPosition();
        Random urandom = new Random(((Object)((Object)this)).hashCode());
        for (int i = 0; i < 6; ++i) {
            this.gCol = this.bCol = urandom.nextFloat() * 0.25f + 0.25f;
            this.rCol = this.bCol;
            float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - camPos.x() + (urandom.nextGaussian() - 1.0) * 0.75);
            float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - camPos.y() + (urandom.nextGaussian() - 1.0) * 0.75);
            float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - camPos.z() + (urandom.nextGaussian() - 1.0) * 0.75);
            float size = urandom.nextFloat() + 0.5f;
            float U0 = this.getU0();
            float U1 = this.getU1();
            float V0 = this.getV0();
            float V1 = this.getV1();
            int color = this.getLightColor(partialTicks);
            this.renderVertex(consumer, quaternionf, pX, pY, pZ, 1.0f, -1.0f, size, U1, V1, color);
            this.renderVertex(consumer, quaternionf, pX, pY, pZ, 1.0f, 1.0f, size, U1, V0, color);
            this.renderVertex(consumer, quaternionf, pX, pY, pZ, -1.0f, 1.0f, size, U0, V0, color);
            this.renderVertex(consumer, quaternionf, pX, pY, pZ, -1.0f, -1.0f, size, U0, V1, color);
        }
    }

    private void renderVertex(VertexConsumer buffer, Quaternionf quaternion, float x, float y, float z, float xOffset, float yOffset, float quadSize, float u, float v, int packedLight) {
        Vector3f vector3f = new Vector3f(xOffset, yOffset, 0.0f).rotate((Quaternionfc)quaternion).mul(quadSize).add(x, y, z);
        buffer.addVertex(vector3f.x(), vector3f.y(), vector3f.z()).setUv(u, v).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(packedLight);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            return new ParticleExSmoke(level, x, y, z);
        }
    }
}

