/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.CustomRenderType;
import com.hbm.particle.ModParticles;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleHadron
extends TextureSheetParticle {
    public ParticleHadron(ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.setSpriteFromAge(ModParticles.HADRON_SPITES);
        this.lifetime = 10;
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        float pX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x);
        float pY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y);
        float pZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z);
        this.alpha = Mth.clamp((float)(1.0f - ((float)this.age + partialTicks) / (float)this.lifetime), (float)0.0f, (float)1.0f);
        this.quadSize = ((float)this.age + partialTicks) * 0.15f;
        this.renderQuad(consumer, camera, pX, pY, pZ);
    }

    private void renderQuad(VertexConsumer consumer, Camera camera, float pX, float pY, float pZ) {
        float u0 = this.sprite.getU0();
        float u1 = this.sprite.getU1();
        float v0 = this.sprite.getV0();
        float v1 = this.sprite.getV1();
        Vector3f l = new Vector3f((Vector3fc)camera.getLeftVector()).mul(this.quadSize);
        Vector3f u = new Vector3f((Vector3fc)camera.getUpVector()).mul(this.quadSize);
        consumer.addVertex(pX - l.x - u.x, pY - l.y - u.y, pZ - l.z - u.z).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv(u1, v1).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX - l.x + u.x, pY - l.y + u.y, pZ - l.z + u.z).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv(u1, v0).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX + l.x + u.x, pY + l.y + u.y, pZ + l.z + u.z).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv(u0, v0).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        consumer.addVertex(pX + l.x - u.x, pY + l.y - u.y, pZ + l.z - u.z).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setUv(u0, v1).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
    }

    public ParticleRenderType getRenderType() {
        return CustomRenderType.PARTICLE_SHEET_ADDITIVE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet sprites) {
            ModParticles.HADRON_SPITES = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleHadron(level, x, y, z);
        }
    }
}

