/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle;

import com.hbm.particle.CustomRenderType;
import com.hbm.particle.ModParticles;
import com.hbm.particle.ParticleMukeCloud;
import com.hbm.render.CustomRenderTypes;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleMukeFlash
extends TextureSheetParticle {
    private final boolean bf;
    private final Random rand = new Random();

    public ParticleMukeFlash(ClientLevel level, double x, double y, double z, boolean bf) {
        super(level, x, y, z);
        this.bf = bf;
        this.lifetime = 20;
        this.setSpriteFromAge(ModParticles.MUKE_FLASH_SPRITES);
    }

    public void tick() {
        super.tick();
        if (this.age == 15) {
            int i;
            ParticleEngine engine = Minecraft.getInstance().particleEngine;
            for (double d = 0.0; d <= 1.8; d += 0.1) {
                engine.add((Particle)this.getCloud(this.level, this.x, this.y, this.z, this.rand.nextGaussian() * 0.05, d + this.rand.nextGaussian() * 0.02, this.rand.nextGaussian() * 0.05));
            }
            for (i = 0; i < 100; ++i) {
                engine.add((Particle)this.getCloud(this.level, this.x, this.y + 0.5, this.z, this.rand.nextGaussian() * 0.5, this.rand.nextInt(5) == 0 ? 0.02 : 0.0, this.rand.nextGaussian() * 0.5));
            }
            for (i = 0; i < 75; ++i) {
                double dz;
                double dx = this.rand.nextGaussian() * 0.5;
                if (dx * dx + (dz = this.rand.nextGaussian() * 0.5) * dz > 1.5) {
                    dx *= 0.5;
                    dz *= 0.5;
                }
                double dy = 1.8 + (this.rand.nextDouble() * 3.0 - 1.5) * (0.75 - (dx * dx + dz * dz)) * 0.5;
                engine.add((Particle)this.getCloud(this.level, this.x, this.y, this.z, dx, dy + this.rand.nextGaussian() * 0.02, dz));
            }
        }
    }

    private ParticleMukeCloud getCloud(ClientLevel level, double x, double y, double z, double mx, double my, double mz) {
        if (this.bf) {
            return new ParticleMukeCloud(level, x, y, z, mx, my, mz, true);
        }
        return new ParticleMukeCloud(level, x, y, z, mx, my, mz, false);
    }

    public void render(VertexConsumer ignored, Camera camera, float partialTicks) {
        Vec3 cameraPosition = camera.getPosition();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer consumer = bufferSource.getBuffer(CustomRenderTypes.entityAdditive(ModParticles.FLARE));
        float dX = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPosition.x);
        float dY = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPosition.y);
        float dZ = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPosition.z);
        this.alpha = Math.clamp(1.0f - ((float)this.age + partialTicks) / (float)this.lifetime, 0.0f, 1.0f);
        this.quadSize = ((float)this.age + partialTicks) * 3.0f + 1.0f;
        float u0 = 0.0f;
        float v0 = 0.0f;
        float u1 = 1.0f;
        float v1 = 1.0f;
        Vector3f l = new Vector3f((Vector3fc)camera.getLeftVector()).mul(this.quadSize);
        Vector3f u = new Vector3f((Vector3fc)camera.getUpVector()).mul(this.quadSize);
        for (int i = 0; i < 24; ++i) {
            this.rand.setSeed(i * 31 + 1);
            float pX = (float)((double)dX + this.rand.nextDouble() * 15.0 - 7.5);
            float pY = (float)((double)dY + this.rand.nextDouble() * 7.5 - 3.75);
            float pZ = (float)((double)dZ + this.rand.nextDouble() * 15.0 - 7.5);
            consumer.addVertex(pX - l.x - u.x, pY - l.y - u.y, pZ - l.z - u.z).setColor(1.0f, 0.9f, 0.75f, this.alpha * 0.5f).setUv(u1, v1).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
            consumer.addVertex(pX - l.x + u.x, pY - l.y + u.y, pZ - l.z + u.z).setColor(1.0f, 0.9f, 0.75f, this.alpha * 0.5f).setUv(u1, v0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
            consumer.addVertex(pX + l.x + u.x, pY + l.y + u.y, pZ + l.z + u.z).setColor(1.0f, 0.9f, 0.75f, this.alpha * 0.5f).setUv(u0, v0).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
            consumer.addVertex(pX + l.x - u.x, pY + l.y - u.y, pZ + l.z - u.z).setColor(1.0f, 0.9f, 0.75f, this.alpha * 0.5f).setUv(u0, v1).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 1.0f, 0.0f).setLight(240);
        }
        bufferSource.endBatch();
    }

    public ParticleRenderType getRenderType() {
        return CustomRenderType.NONE;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Provider(SpriteSet sprites) {
            ModParticles.MUKE_FLASH_SPRITES = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double vx, double vy, double vz) {
            return new ParticleMukeFlash(level, x, y, z, false);
        }
    }
}

